/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.CVModelBuilder;
import hex.ConfusionMatrix;
import hex.FoldAssignment;
import hex.Model;
import hex.ModelBuilderListener;
import hex.ModelCategory;
import hex.ModelExportOption;
import hex.ModelMetrics;
import hex.ModelPreprocessor;
import hex.ModelTrainingEventsPublisher;
import hex.ObjectConsistencyChecker;
import hex.PojoWriter;
import hex.ScoreKeeper;
import hex.SubModelBuilder;
import hex.ToEigenVec;
import hex.genmodel.MojoModel;
import hex.genmodel.utils.DistributionFamily;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import jsr166y.CountedCompleter;
import water.AutoBuffer;
import water.DKV;
import water.ExtensionManager;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.ListenerService;
import water.MRTask;
import water.Scope;
import water.Value;
import water.api.FSIOException;
import water.api.HDFSIOException;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.fvec.FileVec;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.RebalanceDataSet;
import water.fvec.Vec;
import water.rapids.ast.prims.advmath.AstKFold;
import water.udf.CFuncRef;
import water.util.ArrayUtils;
import water.util.Countdown;
import water.util.FrameUtils;
import water.util.IcedHashMap;
import water.util.Log;
import water.util.MRUtils;
import water.util.MathUtils;
import water.util.PrettyPrint;
import water.util.StringUtils;
import water.util.TwoDimTable;
import water.util.VecUtils;

public abstract class ModelBuilder<M extends Model<M, P, O>, P extends Model.Parameters, O extends Model.Output>
extends Iced {
    private transient Workspace _workspace = new Workspace(false);
    public Job<M> _job;
    protected Key<M> _result;
    public String _desc = "Main model";
    private Countdown _build_model_countdown;
    private Countdown _build_step_countdown;
    private static String[] ALGOBASES = new String[0];
    private static String[] SCHEMAS = new String[0];
    private static ModelBuilder[] BUILDERS = new ModelBuilder[0];
    protected boolean _startUpOnceModelBuilder = false;
    public P _parms;
    public P _input_parms;
    protected transient Frame _train;
    protected transient Frame _origTrain;
    protected transient Frame _valid;
    private static final Map<String, Class<? extends ModelBuilder>> _builders = new HashMap<String, Class<? extends ModelBuilder>>();
    private static final Map<Class<? extends Model>, String> _model_class_to_algo = new HashMap<Class<? extends Model>, String>();
    private static final Map<String, String> _algo_to_algo_full_name = new HashMap<String, String>();
    private static final Map<String, Class<? extends Model>> _algo_to_model_class = new HashMap<String, Class<? extends Model>>();
    protected transient ModelTrainingEventsPublisher _eventPublisher;
    protected transient ModelTrainingCoordinator _coordinator;
    protected transient Vec _response;
    protected transient Vec _vresponse;
    protected transient Vec _offset;
    protected transient Vec _weights;
    protected transient Vec _fold;
    protected transient Vec _treatment;
    protected transient String[] _origNames;
    protected transient String[][] _origDomains;
    protected transient double[] _orig_projection_array;
    protected int _nclass;
    transient double[] _distribution;
    protected transient double[] _priorClassDist;
    public ValidationMessage[] _messages = new ValidationMessage[0];
    private int _error_count = -1;
    public transient HashSet<String> _removedCols = new HashSet();

    public ToEigenVec getToEigenVec() {
        return null;
    }

    public boolean shouldReorder(Vec v) {
        return ((Model.Parameters)this._parms)._categorical_encoding.needsResponse() && this.isSupervised();
    }

    public final M get() {
        assert (this._job._result == this._result);
        return (M)((Model)this._job.get());
    }

    public final boolean isStopped() {
        return this._job.isStopped();
    }

    public final Key<M> dest() {
        return this._result;
    }

    final void startClock() {
        this._build_model_countdown = Countdown.fromSeconds(((Model.Parameters)this._parms)._max_runtime_secs);
        this._build_model_countdown.start();
    }

    protected boolean timeout() {
        return this._build_step_countdown != null ? this._build_step_countdown.timedOut() : this._build_model_countdown.timedOut();
    }

    protected boolean stop_requested() {
        return this._job.stop_requested() || this.timeout();
    }

    protected long remainingTimeSecs() {
        return (long)Math.ceil((double)this._build_model_countdown.remainingTime() / 1000.0);
    }

    public static <S extends Model> Key<S> defaultKey(String algoName) {
        return Key.make(H2O.calcNextUniqueModelId(algoName));
    }

    protected ModelBuilder(P parms) {
        this(parms, ModelBuilder.defaultKey(((Model.Parameters)parms).algoName()));
    }

    protected ModelBuilder(P parms, Key<M> key) {
        this._result = key;
        this._job = new Job<M>(this._result, ((Model.Parameters)parms).javaName(), ((Model.Parameters)parms).algoName());
        this._parms = parms;
        this._input_parms = (Model.Parameters)((Iced)parms).clone();
    }

    protected ModelBuilder(P parms, Job<M> job) {
        this._job = job;
        this._result = ModelBuilder.defaultKey(((Model.Parameters)parms).algoName());
        this._parms = parms;
        this._input_parms = (Model.Parameters)((Iced)parms).clone();
    }

    public static String[] algos() {
        return ALGOBASES;
    }

    protected ModelBuilder(P parms, boolean startup_once) {
        this(parms, startup_once, "hex.schemas.");
    }

    protected ModelBuilder(P parms, boolean startup_once, String externalSchemaDirectory) {
        String base = this.getName();
        if (!startup_once) {
            throw H2O.fail("Algorithm " + base + " registration issue. It can only be called at startup.");
        }
        this._startUpOnceModelBuilder = true;
        this._job = null;
        this._result = null;
        this._parms = parms;
        this.init(false);
        if (ArrayUtils.find(ALGOBASES, base) != -1) {
            throw H2O.fail("Only called once at startup per ModelBuilder, and " + base + " has already been called");
        }
        ALGOBASES = Arrays.copyOf(ALGOBASES, ALGOBASES.length + 1);
        BUILDERS = Arrays.copyOf(BUILDERS, BUILDERS.length + 1);
        SCHEMAS = Arrays.copyOf(SCHEMAS, SCHEMAS.length + 1);
        ModelBuilder.ALGOBASES[ModelBuilder.ALGOBASES.length - 1] = base;
        ModelBuilder.BUILDERS[ModelBuilder.BUILDERS.length - 1] = this;
        ModelBuilder.SCHEMAS[ModelBuilder.SCHEMAS.length - 1] = externalSchemaDirectory;
    }

    public static String algoName(String urlName) {
        return ((Model.Parameters)ModelBuilder.BUILDERS[ArrayUtils.find(ModelBuilder.ALGOBASES, urlName)]._parms).algoName();
    }

    public static String javaName(String urlName) {
        return ((Model.Parameters)ModelBuilder.BUILDERS[ArrayUtils.find(ModelBuilder.ALGOBASES, urlName)]._parms).javaName();
    }

    public static String paramName(String urlName) {
        return ModelBuilder.algoName(urlName) + "Parameters";
    }

    public static String schemaDirectory(String urlName) {
        return SCHEMAS[ArrayUtils.find(ALGOBASES, urlName)];
    }

    static <B extends ModelBuilder> Optional<B> getRegisteredBuilder(String urlName) {
        String formattedName = urlName.toLowerCase();
        int idx = ArrayUtils.find(ALGOBASES, formattedName);
        if (idx < 0) {
            return Optional.empty();
        }
        return Optional.of(BUILDERS[idx]);
    }

    public static <P extends Model.Parameters> P makeParameters(String algo) {
        return ((ModelBuilder)ModelBuilder.make((String)algo, null, null))._parms;
    }

    public static <B extends ModelBuilder> B make(String algo, Job job, Key<Model> result) {
        return (B)ModelBuilder.getRegisteredBuilder(algo).map(prototype -> {
            ModelBuilder mb = (ModelBuilder)prototype.clone();
            mb._job = job;
            mb._result = result;
            mb._parms = (Model.Parameters)((Iced)prototype._parms).clone();
            mb._input_parms = (Model.Parameters)((Iced)prototype._parms).clone();
            return mb;
        }).orElseThrow(() -> {
            StringBuilder sb = new StringBuilder();
            sb.append("Unknown algo: '").append(algo).append("'; Extension report: ");
            Log.err(ExtensionManager.getInstance().makeExtensionReport(sb));
            return new IllegalStateException("Algorithm '" + algo + "' is not registered. Available algos: [" + StringUtils.join(",", ALGOBASES) + "]");
        });
    }

    public static <B extends ModelBuilder, MP extends Model.Parameters> B make(MP parms) {
        Key<Model> mKey = ModelBuilder.defaultKey(parms.algoName());
        return ModelBuilder.make(parms, mKey);
    }

    public static <B extends ModelBuilder, MP extends Model.Parameters> B make(MP parms, Key<Model> mKey) {
        Job<Model> mJob = new Job<Model>(mKey, parms.javaName(), parms.algoName());
        B newMB = ModelBuilder.make(parms.algoName(), mJob, mKey);
        ((ModelBuilder)newMB)._parms = (Model.Parameters)parms.clone();
        ((ModelBuilder)newMB)._input_parms = (Model.Parameters)parms.clone();
        return newMB;
    }

    public final Frame train() {
        return this._train;
    }

    public void setTrain(Frame train) {
        this._train = train;
    }

    public void setValid(Frame valid) {
        this._valid = valid;
    }

    public final Frame valid() {
        return this._valid;
    }

    public Vec response() {
        return this._response;
    }

    public Vec vresponse() {
        return this._vresponse == null ? this._response : this._vresponse;
    }

    private void setFinalState() {
        Key<M> reskey = this.dest();
        if (reskey == null) {
            return;
        }
        Model res = (Model)reskey.get();
        if (res != null && res._output != null) {
            ((Model.Output)res._output)._job = this._job;
            ((Model.Output)res._output).stopClock();
            res.write_lock(this._job);
            res.update(this._job);
            res.unlock(this._job);
        }
        Log.info("Completing model " + reskey);
    }

    private void saveModelCheckpointIfConfigured() {
        Model model = (Model)this._result.get();
        if (model != null && !StringUtils.isNullOrEmpty(((Model.Parameters)model._parms)._export_checkpoints_dir)) {
            try {
                model.exportBinaryModel(((Model.Parameters)model._parms)._export_checkpoints_dir + "/" + model._key.toString(), true, new ModelExportOption[0]);
            }
            catch (IOException | FSIOException | HDFSIOException e) {
                throw new H2OIllegalArgumentException("export_checkpoints_dir", "saveModelIfConfigured", e);
            }
        }
    }

    private void notifyModelListeners() {
        Model model = (Model)this._result.get();
        ListenerService.getInstance().report("model_completed", model, this._parms);
    }

    public Job<M> trainModelOnH2ONode() {
        if (this.error_count() > 0) {
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(this);
        }
        this._input_parms = (Model.Parameters)((Iced)this._parms).clone();
        TrainModelRunnable trainModel = new TrainModelRunnable(this);
        H2O.runOnH2ONode(trainModel);
        return this._job;
    }

    public final Job<M> trainModel() {
        return this.trainModel(null);
    }

    public final Job<M> trainModel(final ModelBuilderListener callback) {
        if (this.error_count() > 0) {
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(this);
        }
        this.startClock();
        if (!this.nFoldCV()) {
            Driver driver = this.trainModelImpl();
            driver.setCallback(callback);
            return this._job.start(driver, ((Model.Parameters)this._parms).progressUnits(), ((Model.Parameters)this._parms)._max_runtime_secs);
        }
        return this._job.start(new H2O.H2OCountedCompleter(){

            @Override
            public void compute2() {
                ModelBuilder.this.computeCrossValidation();
                this.tryComplete();
            }

            @Override
            public void onCompletion(CountedCompleter caller) {
                if (callback != null) {
                    callback.onModelSuccess((Model)ModelBuilder.this._result.get());
                }
            }

            @Override
            public boolean onExceptionalCompletion(Throwable ex, CountedCompleter caller) {
                Log.warn("Model training job " + ModelBuilder.this._job._description + " completed with exception: " + ex);
                if (callback != null) {
                    callback.onModelFailure(ex, (Model.Parameters)ModelBuilder.this._parms);
                }
                try {
                    Keyed.remove(ModelBuilder.this._job._result);
                }
                catch (Exception logged) {
                    Log.warn("Exception thrown when removing result from job " + ModelBuilder.this._job._description, logged);
                }
                return true;
            }
        }, (long)(this.nFoldWork() + 1) * ((Model.Parameters)this._parms).progressUnits(), ((Model.Parameters)this._parms)._max_runtime_secs);
    }

    public final M trainModelNested(Frame fr) {
        if (fr != null) {
            this.setTrain(fr);
        }
        if (this.error_count() > 0) {
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(this);
        }
        this.startClock();
        if (!this.nFoldCV()) {
            this.submitTrainModelTask().join();
        } else {
            this.computeCrossValidation();
        }
        return (M)((Model)this._result.get());
    }

    public static <MP extends Model.Parameters> Model trainModelNested(Job<?> job, Key<Model> result, MP params, Frame fr) {
        H2O.runOnH2ONode(new TrainModelNestedRunnable(job, result, params, fr));
        return result.get();
    }

    protected abstract Driver trainModelImpl();

    TrainModelTaskController submitTrainModelTask() {
        Driver d = this.trainModelImpl();
        Barrier b = new Barrier();
        d.setCompleter(b);
        H2O.submitTask(d);
        return new TrainModelTaskController(d, b);
    }

    @Deprecated
    protected int nModelsInParallel() {
        return 0;
    }

    protected int nModelsInParallel(int folds) {
        int n = this.nModelsInParallel();
        if (n > 0) {
            return n;
        }
        return this.nModelsInParallel(folds, 1);
    }

    protected int nModelsInParallel(int folds, int defaultParallelization) {
        if (!((Model.Parameters)this._parms)._parallelize_cross_validation) {
            return 1;
        }
        int parallelization = defaultParallelization;
        if (this._train.byteSize() < this.smallDataSize()) {
            parallelization = folds;
        }
        return Math.min(parallelization, H2O.ARGS.nthreads);
    }

    protected long smallDataSize() {
        return 1000000L;
    }

    private double maxRuntimeSecsPerModel(int cvModelsCount, int parallelization) {
        return cvModelsCount > 0 ? ((Model.Parameters)this._parms)._max_runtime_secs / Math.ceil((double)cvModelsCount / (double)parallelization + 1.0) : ((Model.Parameters)this._parms)._max_runtime_secs;
    }

    protected int nFoldWork() {
        if (((Model.Parameters)this._parms)._fold_column == null) {
            return ((Model.Parameters)this._parms)._nfolds;
        }
        Vec fold = ((Model.Parameters)this._parms)._train.get().vec(((Model.Parameters)this._parms)._fold_column);
        return FoldAssignment.nFoldWork(fold);
    }

    public void computeCrossValidation() {
        assert (this._job.isRunning());
        this._job.setReadyForView(false);
        int N = this.nFoldWork();
        ModelBuilder<M, P, O>[] cvModelBuilders = null;
        try {
            boolean buildMainModel;
            Scope.enter();
            this.init(false);
            ModelBuilder<M, P, O>[] foldAssignment = this.cv_AssignFold(N);
            Vec[] weights = this.cv_makeWeights(N, (FoldAssignment)foldAssignment);
            cvModelBuilders = this.cv_makeFramesAndBuilders(N, weights);
            if (this.useParallelMainModelBuilding(N)) {
                int parallelization = this.nModelsInParallel(N);
                Log.info(this._desc + " will be trained in parallel to the Cross-Validation models (up to " + parallelization + " models running at the same time).");
                LinkedBlockingQueue<ModelTrainingEventsPublisher.Event> events = new LinkedBlockingQueue<ModelTrainingEventsPublisher.Event>();
                for (ModelBuilder<M, P, O> mb : cvModelBuilders) {
                    mb._eventPublisher = new ModelTrainingEventsPublisher(events);
                }
                this._coordinator = new ModelTrainingCoordinator(events, cvModelBuilders);
                ModelBuilder<M, P, O>[] builders = Arrays.copyOf(cvModelBuilders, cvModelBuilders.length + 1);
                builders[builders.length - 1] = this;
                new SubModelBuilder(this._job, builders, parallelization).bulkBuildModels();
                buildMainModel = false;
            } else {
                this.cv_buildModels(N, cvModelBuilders);
                buildMainModel = true;
            }
            ModelMetrics.MetricBuilder[] mbs = this.cv_scoreCVModels(N, weights, cvModelBuilders);
            if (buildMainModel) {
                long time_allocated_to_main_model = (long)(this.maxRuntimeSecsPerModel(N, this.nModelsInParallel(N)) * 1000.0);
                this.buildMainModel(time_allocated_to_main_model);
            }
            if (!cvModelBuilders[0].getName().equals("infogram")) {
                this.cv_mainModelScores(N, mbs, cvModelBuilders);
            }
            this._job.setReadyForView(true);
            DKV.put(this._job);
        }
        catch (Exception e) {
            if (cvModelBuilders != null) {
                Futures fs = new Futures();
                for (ModelBuilder<M, P, O> mb : cvModelBuilders) {
                    DKV.remove(((Model.Parameters)mb._parms)._train, fs);
                    DKV.remove(((Model.Parameters)mb._parms)._valid, fs);
                    DKV.remove(Key.make(super.getPredictionKey()), fs);
                    Keyed.remove(mb._result, fs, true);
                }
                fs.blockForPending();
            }
            throw e;
        }
        finally {
            if (cvModelBuilders != null) {
                for (void var16_25 : cvModelBuilders) {
                    super.cleanUp();
                }
            }
            this.cleanUp();
            Scope.exit(new Key[0]);
        }
    }

    FoldAssignment cv_AssignFold(int N) {
        assert (N >= 2);
        Vec fold = this.train().vec(((Model.Parameters)this._parms)._fold_column);
        if (fold != null) {
            return FoldAssignment.fromUserFoldSpecification(N, fold);
        }
        long seed = ((Model.Parameters)this._parms).getOrMakeRealSeed();
        Log.info("Creating " + N + " cross-validation splits with random number seed: " + seed);
        switch (((Model.Parameters)this._parms)._fold_assignment) {
            case AUTO: 
            case Random: {
                fold = AstKFold.kfoldColumn(this.train().anyVec().makeZero(), N, seed);
                break;
            }
            case Modulo: {
                fold = AstKFold.moduloKfoldColumn(this.train().anyVec().makeZero(), N);
                break;
            }
            case Stratified: {
                fold = AstKFold.stratifiedKFoldColumn(this.response(), N, seed);
                break;
            }
            default: {
                throw H2O.unimpl();
            }
        }
        return FoldAssignment.fromInternalFold(N, fold);
    }

    Vec[] cv_makeWeights(final int N, FoldAssignment foldAssignment) {
        String origWeightsName = ((Model.Parameters)this._parms)._weights_column;
        Vec origWeight = origWeightsName != null ? this.train().vec(origWeightsName) : this.train().anyVec().makeCon(1.0);
        Frame folds_and_weights = new Frame(foldAssignment.getAdaptedFold(), origWeight);
        Vec[] weights = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] nchks) {
                Chunk fold = chks[0];
                Chunk orig = chks[1];
                for (int row = 0; row < orig._len; ++row) {
                    int foldIdx = (int)fold.atd(row);
                    double w = orig.atd(row);
                    for (int f = 0; f < N; ++f) {
                        boolean holdout = foldIdx == f;
                        nchks[2 * f].addNum(holdout ? 0.0 : w);
                        nchks[2 * f + 1].addNum(holdout ? w : 0.0);
                    }
                }
            }
        }.doAll(2 * N, (byte)3, folds_and_weights)).outputFrame().vecs();
        if (origWeightsName == null) {
            origWeight.remove();
        }
        if (((Model.Parameters)this._parms)._keep_cross_validation_fold_assignment) {
            DKV.put(foldAssignment.toFrame(Key.make("cv_fold_assignment_" + this._result.toString())));
        }
        foldAssignment.remove(((Model.Parameters)this._parms)._keep_cross_validation_fold_assignment);
        for (Vec weight : weights) {
            if (!weight.isConst()) continue;
            throw new H2OIllegalArgumentException("Not enough data to create " + N + " random cross-validation splits. Either reduce nfolds, specify a larger dataset (or specify another random number seed, if applicable).");
        }
        return weights;
    }

    private ModelBuilder<M, P, O>[] cv_makeFramesAndBuilders(int N, Vec[] weights) {
        long old_cs = ((Model.Parameters)this._parms).checksum();
        String origDest = this._result.toString();
        String weightName = "__internal_cv_weights__";
        if (this.train().find("__internal_cv_weights__") != -1) {
            throw new H2OIllegalArgumentException("Frame cannot contain a Vec called '__internal_cv_weights__'.");
        }
        Frame cv_fr = new Frame(this.train().names(), this.train().vecs());
        if (((Model.Parameters)this._parms)._weights_column != null) {
            cv_fr.remove(((Model.Parameters)this._parms)._weights_column);
        }
        ModelBuilder[] cvModelBuilders = new ModelBuilder[N];
        ArrayList<Frame> cvFramesForFailedModels = new ArrayList<Frame>();
        double cv_max_runtime_secs = this.maxRuntimeSecsPerModel(N, this.nModelsInParallel(N));
        for (int i = 0; i < N; ++i) {
            String identifier = origDest + "_cv_" + (i + 1);
            Frame cvTrain = new Frame(Key.make(identifier + "_train"), cv_fr.names(), cv_fr.vecs());
            cvTrain.write_lock(this._job);
            cvTrain.add("__internal_cv_weights__", weights[2 * i]);
            cvTrain.update(this._job);
            Frame cvValid = new Frame(Key.make(identifier + "_valid"), cv_fr.names(), cv_fr.vecs());
            cvValid.write_lock(this._job);
            cvValid.add("__internal_cv_weights__", weights[2 * i + 1]);
            cvValid.update(this._job);
            ModelBuilder cv_mb = (ModelBuilder)this.clone();
            cv_mb.setTrain(cvTrain);
            cv_mb._result = Key.make(identifier);
            cv_mb._parms = (Model.Parameters)((Iced)this._parms).clone();
            ((Model.Parameters)cv_mb._parms)._is_cv_model = true;
            ((Model.Parameters)cv_mb._parms)._cv_fold = i;
            ((Model.Parameters)cv_mb._parms)._weights_column = "__internal_cv_weights__";
            ((Model.Parameters)cv_mb._parms).setTrain(cvTrain._key);
            ((Model.Parameters)cv_mb._parms)._valid = cvValid._key;
            ((Model.Parameters)cv_mb._parms)._fold_assignment = Model.Parameters.FoldAssignmentScheme.AUTO;
            ((Model.Parameters)cv_mb._parms)._nfolds = 0;
            ((Model.Parameters)cv_mb._parms)._max_runtime_secs = cv_max_runtime_secs;
            cv_mb.clearValidationErrors();
            cv_mb._input_parms = (Model.Parameters)((Iced)this._parms).clone();
            cv_mb._desc = "Cross-Validation model " + (i + 1) + " / " + N;
            cv_mb.init(false);
            if (cv_mb.error_count() > 0) {
                Log.info("Marking frame for failed cv model for removal: " + cvTrain._key);
                cvFramesForFailedModels.add(cvTrain);
                Log.info("Marking frame for failed cv model for removal: " + cvValid._key);
                cvFramesForFailedModels.add(cvValid);
                for (ValidationMessage vm : cv_mb._messages) {
                    this.message(vm._log_level, vm._field_name, vm._message);
                }
            }
            cvModelBuilders[i] = cv_mb;
        }
        if (this.error_count() > 0) {
            Futures fs = new Futures();
            for (Frame cvf : cvFramesForFailedModels) {
                cvf.vec("__internal_cv_weights__").remove(fs);
                DKV.remove(cvf._key, fs);
                Log.info("Removing frame for failed cv model: " + cvf._key);
            }
            fs.blockForPending();
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(this);
        }
        assert (old_cs == ((Model.Parameters)this._parms).checksum());
        return cvModelBuilders;
    }

    public void cv_buildModels(int N, ModelBuilder<M, P, O>[] cvModelBuilders) {
        this.makeCVModelBuilder(cvModelBuilders, this.nModelsInParallel(N)).bulkBuildModels();
        this.cv_computeAndSetOptimalParameters(cvModelBuilders);
    }

    protected CVModelBuilder makeCVModelBuilder(ModelBuilder<?, ?, ?>[] modelBuilders, int parallelization) {
        return new CVModelBuilder(this._job, modelBuilders, parallelization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelMetrics.MetricBuilder[] cv_scoreCVModels(int N, Vec[] weights, ModelBuilder<M, P, O>[] cvModelBuilders) {
        if (this._job.stop_requested()) {
            Log.info("Skipping scoring of CV models");
            throw new Job.JobCancelledException(this._job);
        }
        assert (weights.length == 2 * N);
        assert (cvModelBuilders.length == N);
        Log.info("Scoring the " + N + " CV models");
        ModelMetrics.MetricBuilder[] mbs = new ModelMetrics.MetricBuilder[N];
        Futures fs = new Futures();
        for (int i = 0; i < N; ++i) {
            if (this._job.stop_requested()) {
                Log.info("Skipping scoring for last " + (N - i) + " out of " + N + " CV models");
                throw new Job.JobCancelledException(this._job);
            }
            Frame cvValid = cvModelBuilders[i].valid();
            Frame preds = null;
            try (Scope.Safe s = Scope.safe(cvValid);){
                Frame adaptFr = new Frame(cvValid);
                if (this.makeCVMetrics(cvModelBuilders[i])) {
                    Model cvModel = (Model)cvModelBuilders[i].dest().get();
                    cvModel.adaptTestForTrain(adaptFr, true, !this.isSupervised());
                    if (this.nclasses() == 2 || ((Model.Parameters)this._parms)._keep_cross_validation_predictions || cvModel.isDistributionHuber()) {
                        String predName = super.getPredictionKey();
                        Model.PredictScoreResult result = cvModel.predictScoreImpl(cvValid, adaptFr, predName, this._job, true, CFuncRef.from(((Model.Parameters)this._parms)._custom_metric_func));
                        preds = result.getPredictions();
                        Scope.untrack(preds);
                        result.makeModelMetrics(cvValid, adaptFr);
                        mbs[i] = result.getMetricBuilder();
                        DKV.put(cvModel);
                    } else {
                        mbs[i] = cvModel.scoreMetrics(adaptFr);
                    }
                }
            }
            catch (Throwable throwable) {
                Scope.track(preds);
                throw throwable;
            }
            Scope.track(preds);
            DKV.remove(((Model.Parameters)cvModelBuilders[i]._parms)._train, fs);
            DKV.remove(((Model.Parameters)cvModelBuilders[i]._parms)._valid, fs);
            weights[2 * i].remove(fs);
            weights[2 * i + 1].remove(fs);
        }
        fs.blockForPending();
        return mbs;
    }

    protected boolean makeCVMetrics(ModelBuilder<?, ?, ?> cvModelBuilder) {
        return !cvModelBuilder.getName().equals("infogram");
    }

    private boolean useParallelMainModelBuilding(int nFolds) {
        int parallelizationLevel = this.nModelsInParallel(nFolds);
        return parallelizationLevel > 1 && ((Model.Parameters)this._parms)._parallelize_cross_validation && this.cv_canBuildMainModelInParallel();
    }

    protected boolean cv_canBuildMainModelInParallel() {
        return false;
    }

    protected boolean cv_updateOptimalParameters(ModelBuilder<M, P, O>[] cvModelBuilders) {
        throw new UnsupportedOperationException();
    }

    protected boolean cv_initStoppingParameters() {
        throw new UnsupportedOperationException();
    }

    private void buildMainModel(long max_runtime_millis) {
        if (this._job.stop_requested()) {
            Log.info("Skipping main model");
            throw new Job.JobCancelledException(this._job);
        }
        assert (this._job.isRunning());
        Log.info("Building main model.");
        Log.info("Remaining time for main model (ms): " + max_runtime_millis);
        this._build_step_countdown = new Countdown(max_runtime_millis, true);
        this.submitTrainModelTask().join();
        this._build_step_countdown = null;
    }

    public void cv_mainModelScores(int N, ModelMetrics.MetricBuilder[] mbs, ModelBuilder<M, P, O>[] cvModelBuilders) {
        Model mainModel = (Model)this._result.get();
        Log.info("Computing " + N + "-fold cross-validation metrics.");
        Key[] cvModKeys = new Key[N];
        ((Model.Output)mainModel._output)._cross_validation_models = ((Model.Parameters)this._parms)._keep_cross_validation_models ? cvModKeys : null;
        Key[] predKeys = new Key[N];
        ((Model.Output)mainModel._output)._cross_validation_predictions = ((Model.Parameters)this._parms)._keep_cross_validation_predictions ? predKeys : null;
        for (int i = 0; i < N; ++i) {
            cvModKeys[i] = cvModelBuilders[i]._result;
            predKeys[i] = Key.make(super.getPredictionKey());
        }
        this.cv_makeAggregateModelMetrics(mbs);
        Frame holdoutPreds = null;
        if (((Model.Parameters)this._parms)._keep_cross_validation_predictions || this.nclasses() == 2 || mainModel.isDistributionHuber()) {
            Key<Frame> cvhp = Key.make("cv_holdout_prediction_" + mainModel._key.toString());
            if (((Model.Parameters)this._parms)._keep_cross_validation_predictions) {
                ((Model.Output)mainModel._output)._cross_validation_holdout_predictions_frame_id = cvhp;
            }
            holdoutPreds = this.combineHoldoutPredictions(predKeys, cvhp);
        }
        if (((Model.Parameters)this._parms)._keep_cross_validation_fold_assignment) {
            ((Model.Output)mainModel._output)._cross_validation_fold_assignment_frame_id = Key.make("cv_fold_assignment_" + this._result.toString());
            Frame xvalidation_fold_assignment_frame = ((Model.Output)mainModel._output)._cross_validation_fold_assignment_frame_id.get();
            if (xvalidation_fold_assignment_frame != null) {
                Scope.untrack(xvalidation_fold_assignment_frame.keysList());
            }
        }
        if (((Model.Parameters)this._parms)._keep_cross_validation_predictions) {
            for (Key k : predKeys) {
                Frame fr = (Frame)DKV.getGet(k);
                if (fr == null) continue;
                Scope.untrack(fr);
            }
        } else {
            int count = Model.deleteAll(predKeys);
            Log.info(count + " CV predictions were removed");
        }
        ((Model.Output)mainModel._output)._cross_validation_metrics = mbs[0].makeModelMetrics(mainModel, ((Model.Parameters)this._parms).train(), null, holdoutPreds);
        if (holdoutPreds != null) {
            if (((Model.Parameters)this._parms)._keep_cross_validation_predictions) {
                Scope.untrack(holdoutPreds);
            } else {
                holdoutPreds.remove();
            }
        }
        ((Model.Output)mainModel._output)._cross_validation_metrics._description = N + "-fold cross-validation on training data (Metrics computed for combined holdout predictions)";
        Log.info(((Model.Output)mainModel._output)._cross_validation_metrics.toString());
        ((Model.Output)mainModel._output)._cross_validation_metrics_summary = this.makeCrossValidationSummaryTable(cvModKeys);
        if (((Model.Output)mainModel._output)._scoring_history != null) {
            ((Model.Output)mainModel._output)._cv_scoring_history = new TwoDimTable[cvModKeys.length];
            for (int i = 0; i < cvModKeys.length; ++i) {
                TwoDimTable sh = ((Model.Output)((Model)cvModKeys[i].get())._output)._scoring_history;
                String[] rowHeaders = sh.getRowHeaders();
                String[] colTypes = sh.getColTypes();
                int tableSize = rowHeaders.length;
                int colSize = colTypes.length;
                TwoDimTable copiedScoringHistory = new TwoDimTable(sh.getTableHeader(), sh.getTableDescription(), sh.getRowHeaders(), sh.getColHeaders(), sh.getColTypes(), sh.getColFormats(), sh.getColHeaderForRowHeaders());
                for (int rowIndex = 0; rowIndex < tableSize; ++rowIndex) {
                    for (int colIndex = 0; colIndex < colSize; ++colIndex) {
                        copiedScoringHistory.set(rowIndex, colIndex, sh.get(rowIndex, colIndex));
                    }
                }
                ((Model.Output)mainModel._output)._cv_scoring_history[i] = copiedScoringHistory;
            }
        }
        if (!((Model.Parameters)this._parms)._keep_cross_validation_models) {
            int count = Model.deleteAll(cvModKeys);
            Log.info(count + " CV models were removed");
        }
        ((Model.Output)mainModel._output)._total_run_time = this._build_model_countdown.elapsedTime();
        DKV.put(mainModel);
    }

    public void cv_makeAggregateModelMetrics(ModelMetrics.MetricBuilder[] mbs) {
        for (int i = 1; i < mbs.length; ++i) {
            mbs[0].reduceForCV(mbs[i]);
        }
    }

    private String getPredictionKey() {
        return "prediction_" + this._result.toString();
    }

    protected void setMaxRuntimeSecsForMainModel() {
        if (((Model.Parameters)this._parms)._max_runtime_secs == 0.0) {
            return;
        }
        if (((Model.Parameters)this._parms)._main_model_time_budget_factor < 0.0) {
            ((Model.Parameters)this._parms)._max_runtime_secs = Math.max(1.0, -((Model.Parameters)this._parms)._main_model_time_budget_factor * (double)this.remainingTimeSecs());
        } else {
            int nFolds = this.nFoldWork();
            ((Model.Parameters)this._parms)._max_runtime_secs = Math.max((double)this.remainingTimeSecs(), ((Model.Parameters)this._parms)._main_model_time_budget_factor * this.maxRuntimeSecsPerModel(nFolds, this.nModelsInParallel(nFolds)) * (double)nFolds / ((double)nFolds - 1.0));
        }
    }

    public void cv_computeAndSetOptimalParameters(ModelBuilder<M, P, O>[] cvModelBuilders) {
    }

    public boolean nFoldCV() {
        return ((Model.Parameters)this._parms)._fold_column != null || ((Model.Parameters)this._parms)._nfolds != 0;
    }

    public abstract ModelCategory[] can_build();

    public BuilderVisibility builderVisibility() {
        return BuilderVisibility.Stable;
    }

    public void clearInitState() {
        this.clearValidationErrors();
    }

    protected boolean logMe() {
        return true;
    }

    public abstract boolean isSupervised();

    public boolean isResponseOptional() {
        return false;
    }

    public boolean hasOffsetCol() {
        return ((Model.Parameters)this._parms)._offset_column != null;
    }

    public boolean hasWeightCol() {
        return ((Model.Parameters)this._parms)._weights_column != null;
    }

    public boolean hasFoldCol() {
        return ((Model.Parameters)this._parms)._fold_column != null;
    }

    public boolean hasTreatmentCol() {
        return ((Model.Parameters)this._parms)._treatment_column != null;
    }

    public int numSpecialCols() {
        return (this.hasOffsetCol() ? 1 : 0) + (this.hasWeightCol() ? 1 : 0) + (this.hasFoldCol() ? 1 : 0) + (this.hasTreatmentCol() ? 1 : 0);
    }

    public boolean havePojo() {
        return false;
    }

    public boolean haveMojo() {
        return false;
    }

    public int nclasses() {
        return this._nclass;
    }

    public final boolean isClassifier() {
        return this.nclasses() > 1;
    }

    protected boolean validateStoppingMetric() {
        return true;
    }

    protected boolean validateBinaryResponse() {
        return true;
    }

    protected void checkEarlyStoppingReproducibility() {
    }

    public int separateFeatureVecs() {
        int res = 0;
        if (((Model.Parameters)this._parms)._weights_column != null) {
            Vec w = this._train.remove(((Model.Parameters)this._parms)._weights_column);
            if (w == null) {
                this.error("_weights_column", "Weights column '" + ((Model.Parameters)this._parms)._weights_column + "' not found in the training frame");
            } else {
                if (!w.isNumeric()) {
                    this.error("_weights_column", "Invalid weights column '" + ((Model.Parameters)this._parms)._weights_column + "', weights must be numeric");
                }
                this._weights = w;
                if (w.naCnt() > 0L) {
                    this.error("_weights_columns", "Weights cannot have missing values.");
                }
                if (w.min() < 0.0) {
                    this.error("_weights_columns", "Weights must be >= 0");
                }
                if (w.max() == 0.0) {
                    this.error("_weights_columns", "Max. weight must be > 0");
                }
                this._train.add(((Model.Parameters)this._parms)._weights_column, w);
                ++res;
            }
        } else {
            this._weights = null;
            assert (!this.hasWeightCol());
        }
        if (((Model.Parameters)this._parms)._offset_column != null) {
            Vec o = this._train.remove(((Model.Parameters)this._parms)._offset_column);
            if (o == null) {
                this.error("_offset_column", "Offset column '" + ((Model.Parameters)this._parms)._offset_column + "' not found in the training frame");
            } else {
                if (!o.isNumeric()) {
                    this.error("_offset_column", "Invalid offset column '" + ((Model.Parameters)this._parms)._offset_column + "', offset must be numeric");
                }
                this._offset = o;
                if (o.naCnt() > 0L) {
                    this.error("_offset_column", "Offset cannot have missing values.");
                }
                if (this._weights == this._offset) {
                    this.error("_offset_column", "Offset must be different from weights");
                }
                this._train.add(((Model.Parameters)this._parms)._offset_column, o);
                ++res;
            }
        } else {
            this._offset = null;
            assert (!this.hasOffsetCol());
        }
        if (((Model.Parameters)this._parms)._fold_column != null) {
            Vec f = this._train.remove(((Model.Parameters)this._parms)._fold_column);
            if (f == null) {
                this.error("_fold_column", "Fold column '" + ((Model.Parameters)this._parms)._fold_column + "' not found in the training frame");
            } else {
                if (!f.isInt() && !f.isCategorical()) {
                    this.error("_fold_column", "Invalid fold column '" + ((Model.Parameters)this._parms)._fold_column + "', fold must be integer or categorical");
                }
                if (f.min() < 0.0) {
                    this.error("_fold_column", "Invalid fold column '" + ((Model.Parameters)this._parms)._fold_column + "', fold must be non-negative");
                }
                if (f.isConst()) {
                    this.error("_fold_column", "Invalid fold column '" + ((Model.Parameters)this._parms)._fold_column + "', fold cannot be constant");
                }
                this._fold = f;
                if (f.naCnt() > 0L) {
                    this.error("_fold_column", "Fold cannot have missing values.");
                }
                if (this._fold == this._weights) {
                    this.error("_fold_column", "Fold must be different from weights");
                }
                if (this._fold == this._offset) {
                    this.error("_fold_column", "Fold must be different from offset");
                }
                this._train.add(((Model.Parameters)this._parms)._fold_column, f);
                ++res;
            }
        } else {
            this._fold = null;
            assert (!this.hasFoldCol());
        }
        if (((Model.Parameters)this._parms)._treatment_column != null) {
            Vec u = this._train.remove(((Model.Parameters)this._parms)._treatment_column);
            if (u == null) {
                this.error("_treatment_column", "Treatment column '" + ((Model.Parameters)this._parms)._treatment_column + "' not found in the training frame");
            } else {
                this._treatment = u;
                if (!u.isCategorical()) {
                    this.error("_treatment_column", "Invalid treatment column '" + ((Model.Parameters)this._parms)._treatment_column + "', treatment column must be categorical");
                }
                this._weights = u;
                if (u.naCnt() > 0L) {
                    this.error("_treatment_column", "Treatment column cannot have missing values.");
                }
                if (u.isCategorical() && u.domain().length != 2) {
                    this.error("_treatment_column", "Treatment column must contains only 0 or 1");
                }
                if (u.min() != 0.0) {
                    this.error("_treatment_column", "Min. treatment column value must be 0");
                }
                if (u.max() != 1.0) {
                    this.error("_treatment_column", "Max. treatment column value must be 1");
                }
                this._train.add(((Model.Parameters)this._parms)._treatment_column, u);
                ++res;
            }
        } else {
            this._treatment = null;
            assert (!this.hasTreatmentCol());
        }
        if (this.isSupervised() && ((Model.Parameters)this._parms)._response_column != null) {
            this._response = this._train.remove(((Model.Parameters)this._parms)._response_column);
            if (this._response == null) {
                if (this.isSupervised()) {
                    this.error("_response_column", "Response column '" + ((Model.Parameters)this._parms)._response_column + "' not found in the training frame");
                }
            } else {
                if (this._response == this._offset) {
                    this.error("_response_column", "Response column must be different from offset_column");
                }
                if (this._response == this._weights) {
                    this.error("_response_column", "Response column must be different from weights_column");
                }
                if (this._response == this._fold) {
                    this.error("_response_column", "Response column must be different from fold_column");
                }
                if (this._response == this._treatment) {
                    this.error("_response_column", "Response column must be different from treatment_column");
                }
                this._train.add(((Model.Parameters)this._parms)._response_column, this._response);
                ++res;
            }
        } else {
            this._response = null;
        }
        return res;
    }

    protected boolean ignoreStringColumns() {
        return true;
    }

    protected boolean ignoreConstColumns() {
        return ((Model.Parameters)this._parms)._ignore_const_cols;
    }

    protected boolean ignoreUuidColumns() {
        return true;
    }

    protected void ignoreBadColumns(int npredictors, boolean expensive) {
        if (((Model.Parameters)this._parms)._ignore_const_cols) {
            new FilterCols(npredictors){

                @Override
                protected boolean filter(Vec v, String name) {
                    boolean isBad = v.isBad();
                    boolean skipConst = ModelBuilder.this.ignoreConstColumns() && v.isConst(ModelBuilder.this.canLearnFromNAs());
                    boolean skipString = ModelBuilder.this.ignoreStringColumns() && v.isString();
                    boolean skipUuid = ModelBuilder.this.ignoreUuidColumns() && v.isUUID();
                    boolean skip = isBad || skipConst || skipString || skipUuid;
                    return skip;
                }
            }.doIt(this._train, "Dropping bad and constant columns: ", expensive);
        }
    }

    protected boolean canLearnFromNAs() {
        return false;
    }

    protected void checkResponseVariable() {
        if (!(this._response == null || this._response.isNumeric() || this._response.isCategorical() || this._response.isTime())) {
            this.error("_response_column", "Use numerical, categorical or time variable. Currently used " + this._response.get_type_str());
        }
    }

    protected void ignoreInvalidColumns(int npredictors, boolean expensive) {
    }

    protected void checkMemoryFootPrint() {
        if (Boolean.getBoolean("sys.ai.h2o.debug.noMemoryCheck")) {
            return;
        }
        this.checkMemoryFootPrint_impl();
    }

    protected void checkMemoryFootPrint_impl() {
    }

    protected boolean computePriorClassDistribution() {
        return this.isClassifier();
    }

    public int error_count() {
        assert (this._error_count >= 0) : "init() not run yet";
        return this._error_count;
    }

    public void hide(String field_name, String message) {
        this.message((byte)5, field_name, message);
    }

    public void info(String field_name, String message) {
        this.message((byte)3, field_name, message);
    }

    public void warn(String field_name, String message) {
        this.message((byte)2, field_name, message);
    }

    public void error(String field_name, String message) {
        this.message((byte)1, field_name, message);
        ++this._error_count;
    }

    public void clearValidationErrors() {
        this._messages = new ValidationMessage[0];
        this._error_count = 0;
    }

    public void message(byte log_level, String field_name, String message) {
        this._messages = Arrays.copyOf(this._messages, this._messages.length + 1);
        this._messages[this._messages.length - 1] = new ValidationMessage(log_level, field_name, message);
        if (log_level == 1) {
            ++this._error_count;
        }
    }

    public ValidationMessage[] getMessagesByFieldAndSeverity(String fieldName, byte logLevel) {
        return (ValidationMessage[])Arrays.stream(this._messages).filter(msg -> msg._field_name.equals(fieldName) && msg._log_level == logLevel).toArray(ValidationMessage[]::new);
    }

    public String validationErrors() {
        return this.validationMessage(1);
    }

    public String validationWarnings() {
        return this.validationMessage(2);
    }

    private String validationMessage(int level) {
        StringBuilder sb = new StringBuilder();
        for (ValidationMessage vm : this._messages) {
            if (vm._log_level != level) continue;
            sb.append(vm.toString()).append("\n");
        }
        return sb.toString();
    }

    public void init(boolean expensive) {
        boolean names_differ;
        Frame va;
        Frame tr;
        if (expensive && this.logMe()) {
            Log.info("Building H2O " + this.getClass().getSimpleName() + " model with these parameters:");
            Log.info(new String(((Iced)this._parms).writeJSON(new AutoBuffer()).buf()));
        }
        this.clearInitState();
        this.initWorkspace(expensive);
        assert (this._parms != null);
        if (((Model.Parameters)this._parms)._train == null) {
            if (expensive) {
                this.error("_train", "Missing training frame");
            }
            return;
        }
        new ObjectConsistencyChecker(((Model.Parameters)this._parms)._train).doAllNodes();
        Frame frame = tr = this._train != null ? this._train : ((Model.Parameters)this._parms).train();
        if (tr == null) {
            this.error("_train", "Missing training frame: " + ((Model.Parameters)this._parms)._train);
            return;
        }
        if (expensive) {
            Scope.protect(((Model.Parameters)this._parms).train(), ((Model.Parameters)this._parms).valid());
        }
        this.setTrain(new Frame(null, (String[])tr._names.clone(), (Vec[])tr.vecs().clone()));
        if (expensive) {
            ((Model.Parameters)this._parms).getOrMakeRealSeed();
        }
        if (((Model.Parameters)this._parms)._categorical_encoding.needsResponse() && !this.isSupervised()) {
            this.error("_categorical_encoding", "Categorical encoding scheme cannot be " + ((Model.Parameters)this._parms)._categorical_encoding.toString() + " - no response column available.");
        }
        if (((Model.Parameters)this._parms)._nfolds < 0 || ((Model.Parameters)this._parms)._nfolds == 1) {
            this.error("_nfolds", "nfolds must be either 0 or >1.");
        }
        if (((Model.Parameters)this._parms)._nfolds > 1 && (long)((Model.Parameters)this._parms)._nfolds > this.train().numRows()) {
            this.error("_nfolds", "nfolds cannot be larger than the number of rows (" + this.train().numRows() + ").");
        }
        if (((Model.Parameters)this._parms)._fold_column != null) {
            this.hide("_fold_assignment", "Fold assignment is ignored when a fold column is specified.");
            if (((Model.Parameters)this._parms)._nfolds > 1) {
                this.error("_nfolds", "nfolds cannot be specified at the same time as a fold column.");
            } else {
                this.hide("_nfolds", "nfolds is ignored when a fold column is specified.");
            }
            if (((Model.Parameters)this._parms)._fold_assignment != Model.Parameters.FoldAssignmentScheme.AUTO && ((Model.Parameters)this._parms)._fold_assignment != null && this._parms != null) {
                this.error("_fold_assignment", "Fold assignment is not allowed in conjunction with a fold column.");
            }
        }
        if (((Model.Parameters)this._parms)._nfolds > 1) {
            this.hide("_fold_column", "Fold column is ignored when nfolds > 1.");
        }
        if (!this.nFoldCV()) {
            this.hide("_keep_cross_validation_models", "Only for cross-validation.");
            this.hide("_keep_cross_validation_predictions", "Only for cross-validation.");
            this.hide("_keep_cross_validation_fold_assignment", "Only for cross-validation.");
            this.hide("_fold_assignment", "Only for cross-validation.");
            if (((Model.Parameters)this._parms)._fold_assignment != Model.Parameters.FoldAssignmentScheme.AUTO && ((Model.Parameters)this._parms)._fold_assignment != null) {
                this.error("_fold_assignment", "Fold assignment is only allowed for cross-validation.");
            }
        }
        if (((Model.Parameters)this._parms)._distribution == DistributionFamily.modified_huber) {
            this.error("_distribution", "Modified Huber distribution is not supported yet.");
        }
        if (((Model.Parameters)this._parms)._distribution != DistributionFamily.tweedie) {
            this.hide("_tweedie_power", "Only for Tweedie Distribution.");
        }
        if (((Model.Parameters)this._parms)._tweedie_power <= 1.0 || ((Model.Parameters)this._parms)._tweedie_power >= 2.0) {
            this.error("_tweedie_power", "Tweedie power must be between 1 and 2 (exclusive). For tweedie power = 1, use Poisson distribution. For tweedie power = 2, use Gamma distribution.");
        }
        if (((Model.Parameters)this._parms)._ignored_columns != null) {
            HashSet<String> ignoreColumnSet = new HashSet<String>(Arrays.asList(((Model.Parameters)this._parms)._ignored_columns));
            Set<String> usedColumns = ((Model.Parameters)this._parms).getUsedColumns(tr._names);
            ignoreColumnSet.removeAll(usedColumns);
            Object[] actualIgnoredColumns = ignoreColumnSet.toArray(new String[0]);
            this._train.remove((String[])actualIgnoredColumns);
            if (expensive) {
                Log.info("Dropping ignored columns: " + Arrays.toString(actualIgnoredColumns));
            }
        }
        if (((Model.Parameters)this._parms)._checkpoint != null) {
            if (DKV.get(((Model.Parameters)this._parms)._checkpoint) == null) {
                this.error("_checkpoint", "Checkpoint has to point to existing model!");
            }
            Model checkpointedModel = ((Model.Parameters)this._parms)._checkpoint.get();
            String[] warnings = checkpointedModel.adaptTestForTrain(this._train, expensive, false);
            for (String warning : warnings) {
                this.warn("_checkpoint", warning);
            }
            this.separateFeatureVecs();
        } else {
            this.ignoreBadColumns(this.separateFeatureVecs(), expensive);
            this.ignoreInvalidColumns(this.separateFeatureVecs(), expensive);
            this.checkResponseVariable();
        }
        if (expensive && this.error_count() == 0 && ((Model.Parameters)this._parms)._auto_rebalance) {
            this.setTrain(this.rebalance(this._train, false, this._result + ".temporary.train"));
            this.separateFeatureVecs();
            this._valid = this.rebalance(this._valid, false, this._result + ".temporary.valid");
        }
        if (this._train.numCols() == 0) {
            this.error("_train", "There are no usable columns to generate model");
        }
        if (this.isSupervised()) {
            if (this._response != null) {
                if (((Model.Parameters)this._parms)._distribution != DistributionFamily.tweedie) {
                    this.hide("_tweedie_power", "Tweedie power is only used for Tweedie distribution.");
                }
                if (((Model.Parameters)this._parms)._distribution != DistributionFamily.quantile) {
                    this.hide("_quantile_alpha", "Quantile (alpha) is only used for Quantile regression.");
                }
                if (expensive) {
                    this.checkDistributions();
                }
                this._nclass = this.init_getNClass();
                if (((Model.Parameters)this._parms)._check_constant_response && this._response.isConst()) {
                    this.error("_response", "Response cannot be constant.");
                }
                if (this.validateBinaryResponse() && this._nclass == 1 && this._response.isBinary(true)) {
                    this.warn("_response", "We have detected that your response column has only 2 unique values (0/1). If you wish to train a binary model instead of a regression model, convert your target column to categorical before training.");
                }
            }
            if (!((Model.Parameters)this._parms)._balance_classes) {
                this.hide("_max_after_balance_size", "Balance classes is false, hide max_after_balance_size");
            } else if (((Model.Parameters)this._parms)._weights_column != null && this._weights != null && !this._weights.isBinary()) {
                this.error("_balance_classes", "Balance classes and observation weights are not currently supported together.");
            }
            if ((double)((Model.Parameters)this._parms)._max_after_balance_size <= 0.0) {
                this.error("_max_after_balance_size", "Max size after balancing needs to be positive, suggest 1.0f");
            }
            if (this._train != null) {
                if (this._train.numCols() <= 1 && !this.getClass().toString().equals("class hex.gam.GAM")) {
                    this.error("_train", "Training data must have at least 2 features (incl. response).");
                }
                if (null == ((Model.Parameters)this._parms)._response_column) {
                    this.error("_response_column", "Response column parameter not set.");
                    return;
                }
                if (this._response != null && this.computePriorClassDistribution()) {
                    if (this.isClassifier() && this.isSupervised()) {
                        if (((Model.Parameters)this._parms).getDistributionFamily() == DistributionFamily.quasibinomial) {
                            String[] quasiDomains = ((VecUtils.CollectDoubleDomain)new VecUtils.CollectDoubleDomain(null, 2).doAll(this._response)).stringDomain(this._response.isInt());
                            MRUtils.ClassDistQuasibinomial cdmt = this._weights != null ? (MRUtils.ClassDistQuasibinomial)new MRUtils.ClassDistQuasibinomial(quasiDomains).doAll(this._response, this._weights) : (MRUtils.ClassDistQuasibinomial)new MRUtils.ClassDistQuasibinomial(quasiDomains).doAll(this._response);
                            this._distribution = cdmt.dist();
                            this._priorClassDist = cdmt.relDist();
                        } else {
                            MRUtils.ClassDist cdmt = this._weights != null ? (MRUtils.ClassDist)new MRUtils.ClassDist(this.nclasses()).doAll(this._response, this._weights) : (MRUtils.ClassDist)new MRUtils.ClassDist(this.nclasses()).doAll(this._response);
                            this._distribution = cdmt.dist();
                            this._priorClassDist = cdmt.relDist();
                        }
                    } else {
                        this._distribution = new double[]{(this._weights != null ? this._weights.mean() : 1.0) * (double)this.train().numRows()};
                        this._priorClassDist = new double[]{1.0};
                    }
                }
            }
            if (!this.isClassifier()) {
                this.hide("_balance_classes", "Balance classes is only applicable to classification problems.");
                this.hide("_class_sampling_factors", "Class sampling factors is only applicable to classification problems.");
                this.hide("_max_after_balance_size", "Max after balance size is only applicable to classification problems.");
                this.hide("_max_confusion_matrix_size", "Max confusion matrix size is only applicable to classification problems.");
            }
            if (this._nclass <= 2) {
                this.hide("_max_confusion_matrix_size", "Only for multi-class classification problems.");
            }
            if (!((Model.Parameters)this._parms)._balance_classes) {
                this.hide("_max_after_balance_size", "Only used with balanced classes");
                this.hide("_class_sampling_factors", "Class sampling factors is only applicable if balancing classes.");
            }
        } else {
            if (!this.isResponseOptional()) {
                this.hide("_response_column", "Ignored for unsupervised methods.");
                this._vresponse = null;
            }
            this.hide("_balance_classes", "Ignored for unsupervised methods.");
            this.hide("_class_sampling_factors", "Ignored for unsupervised methods.");
            this.hide("_max_after_balance_size", "Ignored for unsupervised methods.");
            this.hide("_max_confusion_matrix_size", "Ignored for unsupervised methods.");
            this._response = null;
            this._nclass = 1;
        }
        if (this._nclass > 0x100000) {
            this.error("_nclass", "Too many levels in response column: " + this._nclass + ", maximum supported number of classes is " + 0x100000 + ".");
        }
        if ((va = ((Model.Parameters)this._parms).valid()) != null) {
            if (this.isResponseOptional() && ((Model.Parameters)this._parms)._response_column != null && this._response == null) {
                this._vresponse = va.vec(((Model.Parameters)this._parms)._response_column);
            }
            this._valid = this.adaptFrameToTrain(va, "Validation Frame", "_validation_frame", expensive, false);
            if (!this.isResponseOptional() || ((Model.Parameters)this._parms)._response_column != null && this._valid.find(((Model.Parameters)this._parms)._response_column) >= 0) {
                this._vresponse = this._valid.vec(((Model.Parameters)this._parms)._response_column);
            }
        } else {
            this._valid = null;
            this._vresponse = null;
        }
        if (expensive) {
            boolean scopeTrack = !((Model.Parameters)this._parms)._is_cv_model;
            Frame newtrain = this.applyPreprocessors(this._train, true, scopeTrack);
            if ((newtrain = this.encodeFrameCategoricals(newtrain, scopeTrack)) != this._train) {
                this._origTrain = this._train;
                this._origNames = this._train.names();
                this._origDomains = this._train.domains();
                this.setTrain(newtrain);
                this.separateFeatureVecs();
            } else {
                this._origTrain = null;
            }
            if (this._valid != null) {
                Frame newvalid = this.applyPreprocessors(this._valid, false, scopeTrack);
                newvalid = this.encodeFrameCategoricals(newvalid, scopeTrack);
                this.setValid(newvalid);
            }
            boolean restructured = false;
            Vec[] vecs = this._train.vecs();
            for (int j = 0; j < vecs.length; ++j) {
                Vec v = vecs[j];
                if (v == this._response || v == this._fold || !v.isCategorical() || !this.shouldReorder(v)) continue;
                int len = v.domain().length;
                Log.info("Reordering categorical column " + this._train.name(j) + " (" + len + " levels) based on the mean (weighted) response per level.");
                VecUtils.MeanResponsePerLevelTask mrplt = (VecUtils.MeanResponsePerLevelTask)new VecUtils.MeanResponsePerLevelTask(len).doAll(v, ((Model.Parameters)this._parms)._weights_column != null ? this._train.vec(((Model.Parameters)this._parms)._weights_column) : v.makeCon(1.0), this._train.vec(((Model.Parameters)this._parms)._response_column));
                double[] meanWeightedResponse = mrplt.meanWeightedResponse;
                int[] idx = new int[len];
                for (int i = 0; i < len; ++i) {
                    idx[i] = i;
                }
                ArrayUtils.sort(idx, meanWeightedResponse);
                int[] invIdx = new int[len];
                for (int i = 0; i < len; ++i) {
                    invIdx[idx[i]] = i;
                }
                Vec vNew = ((VecUtils.ReorderTask)new VecUtils.ReorderTask(invIdx).doAll(1, (byte)3, new Frame(v))).outputFrame().anyVec();
                String[] newDomain = new String[len];
                for (int i = 0; i < len; ++i) {
                    newDomain[i] = v.domain()[idx[i]];
                }
                vNew.setDomain(newDomain);
                vecs[j] = vNew;
                restructured = true;
            }
            if (restructured) {
                this._train.restructure(this._train.names(), vecs);
            }
        }
        boolean names_may_differ = ((Model.Parameters)this._parms)._categorical_encoding == Model.Parameters.CategoricalEncodingScheme.Binary;
        boolean bl = names_differ = this._valid != null && ArrayUtils.difference(this._train._names, this._valid._names).length != 0;
        assert (!expensive || names_may_differ || !names_differ);
        if (names_differ && names_may_differ) {
            for (String name : this._train._names) {
                assert (ArrayUtils.contains(this._valid._names, name)) : "Internal error during categorical encoding: training column " + name + " not in validation frame with columns " + Arrays.toString(this._valid._names);
            }
        }
        if (((Model.Parameters)this._parms)._stopping_tolerance < 0.0) {
            this.error("_stopping_tolerance", "Stopping tolerance must be >= 0.");
        }
        if (((Model.Parameters)this._parms)._stopping_tolerance >= 1.0) {
            this.error("_stopping_tolerance", "Stopping tolerance must be < 1.");
        }
        if (((Model.Parameters)this._parms)._stopping_rounds == 0) {
            if (((Model.Parameters)this._parms)._stopping_metric != ScoreKeeper.StoppingMetric.AUTO) {
                this.warn("_stopping_metric", "Stopping metric is ignored for _stopping_rounds=0.");
            }
            if (((Model.Parameters)this._parms)._stopping_tolerance != ((Model.Parameters)this._parms).defaultStoppingTolerance()) {
                this.warn("_stopping_tolerance", "Stopping tolerance is ignored for _stopping_rounds=0.");
            }
        } else if (((Model.Parameters)this._parms)._stopping_rounds < 0) {
            this.error("_stopping_rounds", "Stopping rounds must be >= 0.");
        } else {
            this.checkEarlyStoppingReproducibility();
            if (this.validateStoppingMetric()) {
                if (this.isClassifier()) {
                    if (((Model.Parameters)this._parms)._stopping_metric == ScoreKeeper.StoppingMetric.deviance && !this.getClass().getSimpleName().contains("GLM")) {
                        this.error("_stopping_metric", "Stopping metric cannot be deviance for classification.");
                    }
                } else if (((Model.Parameters)this._parms)._stopping_metric.isClassificationOnly()) {
                    this.error("_stopping_metric", "Stopping metric cannot be " + ((Model.Parameters)this._parms)._stopping_metric + " for regression.");
                }
            }
        }
        if (((Model.Parameters)this._parms)._stopping_metric == ScoreKeeper.StoppingMetric.custom || ((Model.Parameters)this._parms)._stopping_metric == ScoreKeeper.StoppingMetric.custom_increasing) {
            this.checkCustomMetricForEarlyStopping();
        }
        if (((Model.Parameters)this._parms)._max_runtime_secs < 0.0) {
            this.error("_max_runtime_secs", "Max runtime (in seconds) must be greater than 0 (or 0 for unlimited).");
        }
        if (!(StringUtils.isNullOrEmpty(((Model.Parameters)this._parms)._export_checkpoints_dir) || ((Model.Parameters)this._parms)._is_cv_model || H2O.getPM().isWritableDirectory(((Model.Parameters)this._parms)._export_checkpoints_dir))) {
            this.error("_export_checkpoints_dir", "Checkpoints directory path must point to a writable path.");
        }
    }

    protected void checkCustomMetricForEarlyStopping() {
        if (((Model.Parameters)this._parms)._custom_metric_func == null) {
            this.error("_custom_metric_func", "Custom metric function needs to be defined in order to use it for early stopping.");
        }
    }

    public Frame init_adaptFrameToTrain(Frame fr, String frDesc, String field, boolean expensive) {
        Frame adapted = this.adaptFrameToTrain(fr, frDesc, field, expensive, false);
        if (expensive) {
            adapted = this.encodeFrameCategoricals(adapted, true);
        }
        return adapted;
    }

    private Frame adaptFrameToTrain(Frame fr, String frDesc, String field, boolean expensive, boolean catEncoded) {
        if (fr.numRows() == 0L) {
            this.error(field, frDesc + " must have > 0 rows.");
        }
        Frame adapted = new Frame(null, (String[])fr._names.clone(), (Vec[])fr.vecs().clone());
        try {
            String[] msgs = Model.adaptTestForTrain(adapted, null, null, this._train._names, this._train.domains(), this._parms, expensive, true, null, this.getToEigenVec(), this._workspace.getToDelete(expensive), catEncoded);
            Vec response = adapted.vec(((Model.Parameters)this._parms)._response_column);
            if (response == null && ((Model.Parameters)this._parms)._response_column != null && !this.isResponseOptional()) {
                this.error(field, frDesc + " must have a response column '" + ((Model.Parameters)this._parms)._response_column + "'.");
            }
            if (expensive) {
                for (String s : msgs) {
                    Log.info(s);
                    this.warn(field, s);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            this.error(field, iae.getMessage());
        }
        return adapted;
    }

    private Frame applyPreprocessors(Frame fr, boolean isTraining, boolean scopeTrack) {
        if (((Model.Parameters)this._parms)._preprocessors == null) {
            return fr;
        }
        for (Key<ModelPreprocessor> key : ((Model.Parameters)this._parms)._preprocessors) {
            DKV.prefetch(key);
        }
        Frame result = fr;
        for (Key<ModelPreprocessor> key : ((Model.Parameters)this._parms)._preprocessors) {
            Frame encoded;
            ModelPreprocessor preprocessor = key.get();
            Frame frame = encoded = isTraining ? preprocessor.processTrain(result, (Model.Parameters)this._parms) : preprocessor.processValid(result, (Model.Parameters)this._parms);
            if (encoded != result) {
                this.trackEncoded(encoded, scopeTrack);
            }
            result = encoded;
        }
        if (!scopeTrack) {
            Scope.untrack(result);
        }
        return result;
    }

    private Frame encodeFrameCategoricals(Frame fr, boolean scopeTrack) {
        Frame encoded = FrameUtils.categoricalEncoder(fr, ((Model.Parameters)this._parms).getNonPredictors(), ((Model.Parameters)this._parms)._categorical_encoding, this.getToEigenVec(), ((Model.Parameters)this._parms)._max_categorical_levels);
        if (encoded != fr) {
            this.trackEncoded(encoded, scopeTrack);
        }
        return encoded;
    }

    private void trackEncoded(Frame fr, boolean scopeTrack) {
        assert (fr._key != null);
        if (scopeTrack) {
            Scope.track(fr);
        } else {
            this._workspace.getToDelete(true).put(fr._key, Arrays.toString(Thread.currentThread().getStackTrace()));
        }
    }

    protected Frame rebalance(Frame original_fr, boolean local, String name) {
        if (original_fr == null) {
            return null;
        }
        int chunks = this.desiredChunks(original_fr, local);
        String dataset = name.substring(name.length() - 5);
        double rebalanceRatio = this.rebalanceRatio();
        int nonEmptyChunks = original_fr.anyVec().nonEmptyChunks();
        if ((double)nonEmptyChunks >= (double)chunks * rebalanceRatio) {
            if (chunks > 1) {
                Log.info(dataset + " dataset already contains " + nonEmptyChunks + " (non-empty)  chunks. No need to rebalance. [desiredChunks=" + chunks, ", rebalanceRatio=" + rebalanceRatio + "]");
            }
            return original_fr;
        }
        this.raiseReproducibilityWarning(dataset, chunks);
        Log.info("Rebalancing " + dataset + " dataset into " + chunks + " chunks.");
        Key newKey = Key.makeUserHidden(name + ".chunks" + chunks);
        RebalanceDataSet rb = new RebalanceDataSet(original_fr, newKey, chunks);
        H2O.submitTask(rb).join();
        Frame rebalanced_fr = (Frame)DKV.get(newKey).get();
        Scope.track(rebalanced_fr);
        return rebalanced_fr;
    }

    protected void raiseReproducibilityWarning(String datasetName, int chunks) {
    }

    private double rebalanceRatio() {
        String mode = H2O.getCloudSize() == 1 ? "single" : "multi";
        String ratioStr = this.getSysProperty("rebalance.ratio." + mode, "1.0");
        return Double.parseDouble(ratioStr);
    }

    protected int desiredChunks(Frame original_fr, boolean local) {
        if (H2O.getCloudSize() > 1 && Boolean.parseBoolean(this.getSysProperty("rebalance.enableMulti", "false"))) {
            return this.desiredChunkMulti(original_fr);
        }
        return this.desiredChunkSingle(original_fr);
    }

    private int desiredChunkSingle(Frame originalFr) {
        return Math.min((int)Math.ceil((double)originalFr.numRows() / 1000.0), H2O.NUMCPUS);
    }

    private int desiredChunkMulti(Frame fr) {
        for (byte by : fr.types()) {
            if (by == 3 || by == 4) continue;
            Log.warn("Training frame contains columns non-numeric/categorical columns. Using old rebalance logic.");
            return this.desiredChunkSingle(fr);
        }
        long itemCnt = 0L;
        for (Vec v : fr.vecs()) {
            itemCnt += v.length() - v.naCnt();
        }
        int itemSize = 4;
        long l = Math.max(itemCnt * 4L, fr.byteSize());
        int desiredChunkSize = FileVec.calcOptimalChunkSize(l, fr.numCols(), fr.numCols() * 4, H2O.NUMCPUS, H2O.getCloudSize(), false, true);
        int desiredChunks = (int)(l / (long)desiredChunkSize + (long)(l % (long)desiredChunkSize > 0L ? 1 : 0));
        Log.info("Calculated optimal number of chunks = " + desiredChunks);
        return desiredChunks;
    }

    protected String getSysProperty(String name, String def) {
        return System.getProperty("sys.ai.h2o." + name, def);
    }

    protected int init_getNClass() {
        int nclass;
        int n = nclass = this._response.isCategorical() ? this._response.cardinality() : 1;
        if (((Model.Parameters)this._parms)._distribution == DistributionFamily.quasibinomial) {
            nclass = 2;
        }
        return nclass;
    }

    public void checkDistributions() {
        if (((Model.Parameters)this._parms)._distribution == DistributionFamily.poisson) {
            if (this._response.min() < 0.0) {
                this.error("_response", "Response must be non-negative for Poisson distribution.");
            }
        } else if (((Model.Parameters)this._parms)._distribution == DistributionFamily.gamma) {
            if (this._response.min() < 0.0) {
                this.error("_response", "Response must be non-negative for Gamma distribution.");
            }
        } else if (((Model.Parameters)this._parms)._distribution == DistributionFamily.tweedie) {
            if (((Model.Parameters)this._parms)._tweedie_power >= 2.0 || ((Model.Parameters)this._parms)._tweedie_power <= 1.0) {
                this.error("_tweedie_power", "Tweedie power must be between 1 and 2.");
            }
            if (this._response.min() < 0.0) {
                this.error("_response", "Response must be non-negative for Tweedie distribution.");
            }
        } else if (((Model.Parameters)this._parms)._distribution == DistributionFamily.quantile) {
            if (((Model.Parameters)this._parms)._quantile_alpha > 1.0 || ((Model.Parameters)this._parms)._quantile_alpha < 0.0) {
                this.error("_quantile_alpha", "Quantile alpha must be between 0 and 1.");
            }
        } else if (((Model.Parameters)this._parms)._distribution == DistributionFamily.huber && (((Model.Parameters)this._parms)._huber_alpha < 0.0 || ((Model.Parameters)this._parms)._huber_alpha > 1.0)) {
            this.error("_huber_alpha", "Huber alpha must be between 0 and 1.");
        }
    }

    Frame combineHoldoutPredictions(Key<Frame>[] predKeys, Key<Frame> key) {
        int precision = ((Model.Parameters)this._parms)._keep_cross_validation_predictions_precision;
        if (precision < 0) {
            precision = this.isClassifier() ? 8 : 0;
        }
        return ModelBuilder.combineHoldoutPredictions(predKeys, key, precision);
    }

    static Frame combineHoldoutPredictions(Key<Frame>[] predKeys, Key<Frame> key, int precision) {
        int N = predKeys.length;
        Frame template = predKeys[0].get();
        Vec[] vecs = new Vec[N * template.numCols()];
        int idx = 0;
        for (Key<Frame> predKey : predKeys) {
            for (int j = 0; j < predKey.get().numCols(); ++j) {
                vecs[idx++] = predKey.get().vec(j);
            }
        }
        HoldoutPredictionCombiner combiner = ModelBuilder.makeHoldoutPredictionCombiner(N, template.numCols(), precision);
        return ((HoldoutPredictionCombiner)combiner.doAll(template.types(), new Frame(vecs))).outputFrame(key, template.names(), template.domains());
    }

    static HoldoutPredictionCombiner makeHoldoutPredictionCombiner(int folds, int cols, int precision) {
        if (precision < 0) {
            throw new IllegalArgumentException("Precision cannot be negative, got precision = " + precision);
        }
        if (precision == 0) {
            return new HoldoutPredictionCombiner(folds, cols);
        }
        return new ApproximatingHoldoutPredictionCombiner(folds, cols, precision);
    }

    private TwoDimTable makeCrossValidationSummaryTable(Key[] cvmodels) {
        if (cvmodels == null || cvmodels.length == 0) {
            return null;
        }
        int N = cvmodels.length;
        int extra_length = 2;
        Object[] colTypes = new String[N + extra_length];
        Arrays.fill(colTypes, "float");
        Object[] colFormats = new String[N + extra_length];
        Arrays.fill(colFormats, "%f");
        String[] colNames = new String[N + extra_length];
        colNames[0] = "mean";
        colNames[1] = "sd";
        for (int i = 0; i < N; ++i) {
            colNames[i + extra_length] = "cv_" + (i + 1) + "_valid";
        }
        HashSet<String> excluded = new HashSet<String>();
        excluded.add("total_rows");
        excluded.add("makeSchema");
        excluded.add("hr");
        excluded.add("frame");
        excluded.add("model");
        excluded.add("remove");
        excluded.add("cm");
        excluded.add("auc_obj");
        excluded.add("aucpr");
        if (null == ((Model.Parameters)this._parms)._custom_metric_func) {
            excluded.add("custom");
            excluded.add("custom_increasing");
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        Model m = (Model)DKV.getGet(cvmodels[0]);
        ModelMetrics mm = ((Model.Output)m._output)._validation_metrics;
        if (mm != null) {
            for (Method meth : mm.getClass().getMethods()) {
                if (excluded.contains(meth.getName())) continue;
                try {
                    double c = (Double)meth.invoke((Object)mm, new Object[0]);
                    methods.add(meth);
                }
                catch (Exception c) {
                    // empty catch block
                }
            }
            ConfusionMatrix confusionMatrix = mm.cm();
            if (confusionMatrix != null) {
                for (Method meth : confusionMatrix.getClass().getMethods()) {
                    if (excluded.contains(meth.getName())) continue;
                    try {
                        double c = (Double)meth.invoke((Object)confusionMatrix, new Object[0]);
                        methods.add(meth);
                    }
                    catch (Exception c) {
                        // empty catch block
                    }
                }
            }
        }
        TreeSet<String> rowNames = new TreeSet<String>();
        for (Method method : methods) {
            rowNames.add(method.getName());
        }
        ArrayList<Method> meths = new ArrayList<Method>();
        block12: for (String n : rowNames) {
            for (Method m3 : methods) {
                if (!m3.getName().equals(n)) continue;
                meths.add(m3);
                continue block12;
            }
        }
        int n = rowNames.size();
        TwoDimTable table = new TwoDimTable("Cross-Validation Metrics Summary", null, rowNames.toArray(new String[0]), colNames, (String[])colTypes, (String[])colFormats, "");
        MathUtils.BasicStats stats = new MathUtils.BasicStats(n);
        double[][] vals = new double[N][n];
        int i = 0;
        for (Key km : cvmodels) {
            Model m4 = (Model)DKV.getGet(km);
            if (m4 == null) continue;
            ModelMetrics mm2 = ((Model.Output)m4._output)._validation_metrics;
            int j = 0;
            for (Method meth : meths) {
                if (excluded.contains(meth.getName())) continue;
                try {
                    double val;
                    vals[i][j] = val = ((Double)meth.invoke((Object)mm2, new Object[0])).doubleValue();
                    table.set(j++, i + extra_length, Float.valueOf((float)val));
                }
                catch (Throwable val) {
                    // empty catch block
                }
                if (mm2.cm() == null) continue;
                try {
                    vals[i][j] = val = ((Double)meth.invoke((Object)mm2.cm(), new Object[0])).doubleValue();
                    table.set(j++, i + extra_length, Float.valueOf((float)val));
                }
                catch (Throwable throwable) {}
            }
            ++i;
        }
        MathUtils.SimpleStats simpleStats = new MathUtils.SimpleStats(n);
        for (i = 0; i < N; ++i) {
            simpleStats.add(vals[i], 1.0);
        }
        for (i = 0; i < n; ++i) {
            table.set(i, 0, Float.valueOf((float)simpleStats.mean()[i]));
            table.set(i, 1, Float.valueOf((float)simpleStats.sigma()[i]));
        }
        Log.info(table);
        return table;
    }

    public String getName() {
        return this.getClass().getSimpleName().toLowerCase();
    }

    private void cleanUp() {
        this._workspace.cleanUp();
    }

    protected final void initWorkspace(boolean expensive) {
        if (expensive) {
            this._workspace = new Workspace(true);
        }
    }

    public PojoWriter makePojoWriter(Model<?, ?, ?> genericModel, MojoModel mojoModel) {
        throw new UnsupportedOperationException("MOJO Model for algorithm '" + mojoModel._algoName + "' doesn't support conversion to POJO.");
    }

    static class Workspace {
        private final IcedHashMap<Key, String> _toDelete;

        private Workspace(boolean expensive) {
            this._toDelete = expensive ? new IcedHashMap() : null;
        }

        IcedHashMap<Key, String> getToDelete(boolean expensive) {
            if (!expensive) {
                return null;
            }
            if (this._toDelete == null) {
                throw new IllegalStateException("ModelBuilder was not correctly initialized. Expensive phase requires field `_toDelete` to be non-null. Does your implementation of init method call super.init(true) or alternatively initWorkspace(true)?");
            }
            return this._toDelete;
        }

        void cleanUp() {
            Key[] tracked;
            if (this._toDelete == null) {
                return;
            }
            for (Key k : tracked = this._toDelete.keySet().toArray(new Key[0])) {
                Value v = DKV.get(k);
                if (v == null) continue;
                if (v.isFrame()) {
                    Scope.track(v.get(Frame.class));
                    continue;
                }
                if (v.isVec()) {
                    Scope.track(v.get(Vec.class));
                    continue;
                }
                Scope.track_generic(v.get(Keyed.class));
            }
        }
    }

    static class ApproximatingHoldoutPredictionCombiner
    extends HoldoutPredictionCombiner {
        private final int _precision;

        public ApproximatingHoldoutPredictionCombiner(int folds, int cols, int precision) {
            super(folds, cols);
            this._precision = precision;
        }

        @Override
        protected void populateChunk(NewChunk nc, double[] vals) {
            long scale = PrettyPrint.pow10i(this._precision);
            for (double val : vals) {
                if (Double.isNaN(val)) {
                    nc.addNA();
                    continue;
                }
                long approx = Math.round(val * (double)scale);
                nc.addNum(approx, -this._precision);
            }
        }
    }

    static class HoldoutPredictionCombiner
    extends MRTask<HoldoutPredictionCombiner> {
        int _folds;
        int _cols;

        public HoldoutPredictionCombiner(int folds, int cols) {
            this._folds = folds;
            this._cols = cols;
        }

        @Override
        public final void map(Chunk[] cs, NewChunk[] nc) {
            for (int c = 0; c < this._cols; ++c) {
                double[] vals = new double[cs[0].len()];
                ChunkVisitor.CombiningDoubleAryVisitor visitor = new ChunkVisitor.CombiningDoubleAryVisitor(vals);
                for (int f = 0; f < this._folds; ++f) {
                    cs[f * this._cols + c].processRows(visitor, 0, vals.length);
                    visitor.reset();
                }
                this.populateChunk(nc[c], vals);
            }
        }

        protected void populateChunk(NewChunk nc, double[] vals) {
            nc.setDoubles(vals);
        }
    }

    public abstract class FilterCols {
        final int _specialVecs;

        public FilterCols(int n) {
            this._specialVecs = n;
        }

        protected abstract boolean filter(Vec var1, String var2);

        public void doIt(Frame f, String msg, boolean expensive) {
            ArrayList<Integer> rmcolsList = new ArrayList<Integer>();
            for (int i = 0; i < f.vecs().length - this._specialVecs; ++i) {
                if (!this.filter(f.vec(i), f._names[i])) continue;
                rmcolsList.add(i);
            }
            if (!rmcolsList.isEmpty()) {
                ModelBuilder.this._removedCols = new HashSet(rmcolsList.size());
                int[] rmcols = new int[rmcolsList.size()];
                for (int i = 0; i < rmcols.length; ++i) {
                    rmcols[i] = (Integer)rmcolsList.get(i);
                    ModelBuilder.this._removedCols.add(f._names[rmcols[i]]);
                }
                f.remove(rmcols);
                msg = msg + ModelBuilder.this._removedCols.toString();
                ModelBuilder.this.warn("_train", msg);
                if (expensive) {
                    Log.info(msg);
                }
            }
        }
    }

    public static final class ValidationMessage
    extends Iced {
        final byte _log_level;
        final String _field_name;
        final String _message;

        public ValidationMessage(byte log_level, String field_name, String message) {
            this._log_level = log_level;
            this._field_name = field_name;
            this._message = message;
            Log.log(log_level, field_name + ": " + message);
        }

        public int log_level() {
            return this._log_level;
        }

        public String field() {
            return this._field_name;
        }

        public String message() {
            return this._message;
        }

        public String toString() {
            return Log.LVLS[this._log_level] + " on field: " + this._field_name + ": " + this._message;
        }
    }

    public static enum BuilderVisibility {
        Experimental,
        Beta,
        Stable;


        public static BuilderVisibility valueOfIgnoreCase(String value) throws IllegalArgumentException {
            BuilderVisibility[] values = BuilderVisibility.values();
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].name().equalsIgnoreCase(value)) continue;
                return values[i];
            }
            throw new IllegalArgumentException(String.format("Algorithm availability level of '%s' is not known. Available levels: %s", value, Arrays.toString((Object[])values)));
        }
    }

    public class ModelTrainingCoordinator {
        private final BlockingQueue<ModelTrainingEventsPublisher.Event> _events;
        private final ModelBuilder<M, P, O>[] _cvModelBuilders;
        private int _inProgress;

        public ModelTrainingCoordinator(BlockingQueue<ModelTrainingEventsPublisher.Event> events, ModelBuilder<M, P, O>[] cvModelBuilders) {
            this._events = events;
            this._cvModelBuilders = cvModelBuilders;
            this._inProgress = this._cvModelBuilders.length;
        }

        public void initStoppingParameters() {
            ModelBuilder.this.cv_initStoppingParameters();
        }

        public void updateParameters() {
            try {
                while (this._inProgress > 0) {
                    ModelTrainingEventsPublisher.Event e = this._events.take();
                    switch (e) {
                        case ALL_DONE: {
                            --this._inProgress;
                            break;
                        }
                        case ONE_DONE: {
                            if (!ModelBuilder.this.cv_updateOptimalParameters(this._cvModelBuilders)) break;
                            return;
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Failed to update model parameters based on result of CV model training", e);
            }
            ModelBuilder.this.cv_updateOptimalParameters(this._cvModelBuilders);
        }
    }

    class TrainModelTaskController {
        private final Driver _driver;
        private final Barrier _barrier;

        TrainModelTaskController(Driver driver, Barrier barrier) {
            this._driver = driver;
            this._barrier = barrier;
        }

        void join() {
            this._barrier.join();
        }

        void cancel(boolean mayInterruptIfRunning) {
            this._driver.cancel(mayInterruptIfRunning);
        }
    }

    private static class Barrier
    extends CountedCompleter {
        private Barrier() {
        }

        @Override
        public void compute() {
        }
    }

    private static class TrainModelNestedRunnable
    extends H2O.RemoteRunnable<TrainModelNestedRunnable> {
        private Job<?> _job;
        private Key<Model> _key;
        private Model.Parameters _parms;
        private Frame _fr;

        private TrainModelNestedRunnable(Job<?> job, Key<Model> key, Model.Parameters parms, Frame fr) {
            this._job = job;
            this._key = key;
            this._parms = parms;
            this._fr = fr;
        }

        @Override
        public void run() {
            Object mb = ModelBuilder.make(this._parms.algoName(), this._job, this._key);
            ((ModelBuilder)mb)._parms = this._parms;
            ((ModelBuilder)mb)._input_parms = (Model.Parameters)this._parms.clone();
            ((ModelBuilder)mb).trainModelNested(this._fr);
        }
    }

    private static class TrainModelRunnable
    extends H2O.RemoteRunnable<TrainModelRunnable> {
        private transient ModelBuilder _mb;
        private Job<Model> _job;
        private Key<Model> _key;
        private Model.Parameters _parms;
        private Model.Parameters _input_parms;

        private TrainModelRunnable(ModelBuilder mb) {
            this._mb = mb;
            this._job = this._mb._job;
            this._key = this._job._result;
            this._parms = this._mb._parms;
            this._input_parms = this._mb._input_parms;
        }

        @Override
        public void setupOnRemote() {
            this._mb = ModelBuilder.make(this._parms.algoName(), this._job, this._key);
            this._mb._parms = this._parms;
            this._mb._input_parms = this._input_parms;
            this._mb.init(false);
        }

        @Override
        public void run() {
            this._mb.trainModel();
        }
    }

    protected abstract class Driver
    extends H2O.H2OCountedCompleter<Driver> {
        private ModelBuilderListener _callback;

        protected Driver() {
        }

        public void setCallback(ModelBuilderListener callback) {
            this._callback = callback;
        }

        @Override
        public void compute2() {
            block5: {
                block4: {
                    try {
                        Scope.enter();
                        ((Model.Parameters)ModelBuilder.this._parms).read_lock_frames(ModelBuilder.this._job);
                        this.computeImpl();
                        this.computeParameters();
                        ModelBuilder.this.saveModelCheckpointIfConfigured();
                        ModelBuilder.this.notifyModelListeners();
                        ((Model.Parameters)ModelBuilder.this._parms).read_unlock_frames(ModelBuilder.this._job);
                        if (!((Model.Parameters)ModelBuilder.this._parms)._is_cv_model) break block4;
                    }
                    catch (Throwable throwable) {
                        ((Model.Parameters)ModelBuilder.this._parms).read_unlock_frames(ModelBuilder.this._job);
                        if (((Model.Parameters)ModelBuilder.this._parms)._is_cv_model) {
                            Key[] keep = ModelBuilder.this._workspace == null ? new Key[]{} : ModelBuilder.this._workspace.getToDelete(true).keySet().toArray(new Key[0]);
                            Scope.exit(keep);
                        } else {
                            ModelBuilder.this.cleanUp();
                            Scope.exit(new Key[0]);
                        }
                        throw throwable;
                    }
                    Key[] keep = ModelBuilder.this._workspace == null ? new Key[]{} : ModelBuilder.this._workspace.getToDelete(true).keySet().toArray(new Key[0]);
                    Scope.exit(keep);
                    break block5;
                }
                ModelBuilder.this.cleanUp();
                Scope.exit(new Key[0]);
            }
            this.tryComplete();
        }

        @Override
        public void onCompletion(CountedCompleter caller) {
            ModelBuilder.this.setFinalState();
            if (this._callback != null) {
                this._callback.onModelSuccess((Model)ModelBuilder.this._result.get());
            }
        }

        @Override
        public boolean onExceptionalCompletion(Throwable ex, CountedCompleter caller) {
            ModelBuilder.this.setFinalState();
            if (this._callback != null) {
                this._callback.onModelFailure(ex, (Model.Parameters)ModelBuilder.this._parms);
            }
            return true;
        }

        public abstract void computeImpl();

        public final void computeParameters() {
            Model model = (Model)ModelBuilder.this._result.get();
            if (model != null) {
                model.write_lock(ModelBuilder.this._job);
                model.setInputParms(ModelBuilder.this._input_parms);
                model.update(ModelBuilder.this._job);
                model.unlock(ModelBuilder.this._job);
            }
        }
    }
}

