/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.IdentityFunction;
import hex.InverseFunction;
import hex.LinkFunction;
import hex.LogFunction;
import hex.LogitFunction;
import hex.OlogitFunction;
import hex.OloglogFunction;
import hex.OprobitFunction;
import hex.genmodel.utils.LinkFunctionType;
import water.H2O;

public class LinkFunctionFactory {
    public static LinkFunction getLinkFunction(String type) {
        return LinkFunctionFactory.getLinkFunction(LinkFunctionType.valueOf((String)type));
    }

    public static LinkFunction getLinkFunction(LinkFunctionType type) {
        switch (type) {
            case log: {
                return new LogFunction();
            }
            case logit: {
                return new LogitFunction();
            }
            case identity: {
                return new IdentityFunction();
            }
            case ologit: {
                return new OlogitFunction();
            }
            case ologlog: {
                return new OloglogFunction();
            }
            case oprobit: {
                return new OprobitFunction();
            }
            case inverse: {
                return new InverseFunction();
            }
        }
        throw H2O.unimpl("The" + type + " link function is not implemented.");
    }
}

