/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Distribution;
import hex.DistributionFactory;
import hex.LinkFunction;
import hex.LogFunction;
import hex.genmodel.utils.DistributionFamily;

class GammaDistribution
extends Distribution {
    public GammaDistribution(DistributionFamily family) {
        super(family, (LinkFunction)new LogFunction());
    }

    @Override
    public double deviance(double w, double y, double f) {
        return 2.0 * w * (DistributionFactory.LogExpUtil.log(f / y) + (y == 0.0 && f == 0.0 ? 1.0 : y / f) - 1.0);
    }

    @Override
    public double negHalfGradient(double y, double f) {
        return y * DistributionFactory.LogExpUtil.exp(-f) - 1.0;
    }

    @Override
    public double initFNum(double w, double o, double y) {
        return w * y * this.linkInv(-o);
    }

    @Override
    public double initFDenom(double w, double o, double y) {
        return w;
    }

    @Override
    public double gammaNum(double w, double y, double z, double f) {
        return w * (z + 1.0);
    }

    @Override
    public double gammaDenom(double w, double y, double z, double f) {
        return w;
    }
}

