/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.redismock.commands;

import ai.grakn.redismock.RedisBase;
import ai.grakn.redismock.RedisClient;
import ai.grakn.redismock.RedisCommand;
import ai.grakn.redismock.Response;
import ai.grakn.redismock.Slice;
import ai.grakn.redismock.commands.RO_append;
import ai.grakn.redismock.commands.RO_brpoplpush;
import ai.grakn.redismock.commands.RO_decr;
import ai.grakn.redismock.commands.RO_decrby;
import ai.grakn.redismock.commands.RO_del;
import ai.grakn.redismock.commands.RO_exec;
import ai.grakn.redismock.commands.RO_exists;
import ai.grakn.redismock.commands.RO_expire;
import ai.grakn.redismock.commands.RO_expireat;
import ai.grakn.redismock.commands.RO_flushall;
import ai.grakn.redismock.commands.RO_get;
import ai.grakn.redismock.commands.RO_getbit;
import ai.grakn.redismock.commands.RO_getset;
import ai.grakn.redismock.commands.RO_incr;
import ai.grakn.redismock.commands.RO_incrby;
import ai.grakn.redismock.commands.RO_keys;
import ai.grakn.redismock.commands.RO_lindex;
import ai.grakn.redismock.commands.RO_llen;
import ai.grakn.redismock.commands.RO_lpop;
import ai.grakn.redismock.commands.RO_lpush;
import ai.grakn.redismock.commands.RO_lpushx;
import ai.grakn.redismock.commands.RO_lrange;
import ai.grakn.redismock.commands.RO_lrem;
import ai.grakn.redismock.commands.RO_mget;
import ai.grakn.redismock.commands.RO_mset;
import ai.grakn.redismock.commands.RO_pexpire;
import ai.grakn.redismock.commands.RO_pexpireat;
import ai.grakn.redismock.commands.RO_pfadd;
import ai.grakn.redismock.commands.RO_pfcount;
import ai.grakn.redismock.commands.RO_pfmerge;
import ai.grakn.redismock.commands.RO_ping;
import ai.grakn.redismock.commands.RO_psetex;
import ai.grakn.redismock.commands.RO_pttl;
import ai.grakn.redismock.commands.RO_publish;
import ai.grakn.redismock.commands.RO_quit;
import ai.grakn.redismock.commands.RO_rpop;
import ai.grakn.redismock.commands.RO_rpoplpush;
import ai.grakn.redismock.commands.RO_rpush;
import ai.grakn.redismock.commands.RO_set;
import ai.grakn.redismock.commands.RO_setbit;
import ai.grakn.redismock.commands.RO_setex;
import ai.grakn.redismock.commands.RO_setnx;
import ai.grakn.redismock.commands.RO_strlen;
import ai.grakn.redismock.commands.RO_subscribe;
import ai.grakn.redismock.commands.RO_ttl;
import ai.grakn.redismock.commands.RO_unsubscribe;
import ai.grakn.redismock.commands.RedisOperation;
import ai.grakn.redismock.expecptions.WrongNumberOfArgumentsException;
import ai.grakn.redismock.expecptions.WrongValueTypeException;
import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisOperationExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RedisOperationExecutor.class);
    private final RedisClient owner;
    private final RedisBase base;
    private boolean transactionModeOn;
    private List<RedisOperation> transaction;

    public RedisOperationExecutor(RedisBase base, RedisClient owner) {
        this.base = base;
        this.owner = owner;
        this.transactionModeOn = false;
        this.transaction = new ArrayList<RedisOperation>();
    }

    private RedisOperation buildSimpleOperation(String name, List<Slice> params) {
        switch (name) {
            case "set": {
                return new RO_set(this.base, params);
            }
            case "setex": {
                return new RO_setex(this.base, params);
            }
            case "psetex": {
                return new RO_psetex(this.base, params);
            }
            case "setnx": {
                return new RO_setnx(this.base, params);
            }
            case "setbit": {
                return new RO_setbit(this.base, params);
            }
            case "append": {
                return new RO_append(this.base, params);
            }
            case "get": {
                return new RO_get(this.base, params);
            }
            case "getbit": {
                return new RO_getbit(this.base, params);
            }
            case "ttl": {
                return new RO_ttl(this.base, params);
            }
            case "pttl": {
                return new RO_pttl(this.base, params);
            }
            case "expire": {
                return new RO_expire(this.base, params);
            }
            case "pexpire": {
                return new RO_pexpire(this.base, params);
            }
            case "incr": {
                return new RO_incr(this.base, params);
            }
            case "incrby": {
                return new RO_incrby(this.base, params);
            }
            case "decr": {
                return new RO_decr(this.base, params);
            }
            case "decrby": {
                return new RO_decrby(this.base, params);
            }
            case "pfcount": {
                return new RO_pfcount(this.base, params);
            }
            case "pfadd": {
                return new RO_pfadd(this.base, params);
            }
            case "pfmerge": {
                return new RO_pfmerge(this.base, params);
            }
            case "mget": {
                return new RO_mget(this.base, params);
            }
            case "mset": {
                return new RO_mset(this.base, params);
            }
            case "getset": {
                return new RO_getset(this.base, params);
            }
            case "strlen": {
                return new RO_strlen(this.base, params);
            }
            case "del": {
                return new RO_del(this.base, params);
            }
            case "exists": {
                return new RO_exists(this.base, params);
            }
            case "expireat": {
                return new RO_expireat(this.base, params);
            }
            case "pexpireat": {
                return new RO_pexpireat(this.base, params);
            }
            case "lpush": {
                return new RO_lpush(this.base, params);
            }
            case "rpush": {
                return new RO_rpush(this.base, params);
            }
            case "lpushx": {
                return new RO_lpushx(this.base, params);
            }
            case "lrange": {
                return new RO_lrange(this.base, params);
            }
            case "llen": {
                return new RO_llen(this.base, params);
            }
            case "lpop": {
                return new RO_lpop(this.base, params);
            }
            case "rpop": {
                return new RO_rpop(this.base, params);
            }
            case "lindex": {
                return new RO_lindex(this.base, params);
            }
            case "rpoplpush": {
                return new RO_rpoplpush(this.base, params);
            }
            case "brpoplpush": {
                return new RO_brpoplpush(this.base, params);
            }
            case "subscribe": {
                return new RO_subscribe(this.base, this.owner, params);
            }
            case "unsubscribe": {
                return new RO_unsubscribe(this.base, this.owner, params);
            }
            case "publish": {
                return new RO_publish(this.base, params);
            }
            case "flushall": {
                return new RO_flushall(this.base, params);
            }
            case "lrem": {
                return new RO_lrem(this.base, params);
            }
            case "quit": {
                return new RO_quit(this.base, this.owner, params);
            }
            case "exec": {
                this.transactionModeOn = false;
                return new RO_exec(this.base, this.transaction, params);
            }
            case "ping": {
                return new RO_ping(this.base, params);
            }
            case "keys": {
                return new RO_keys(this.base, params);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported operation '%s'", name));
    }

    public synchronized Slice execCommand(RedisCommand command) {
        Preconditions.checkArgument((command.getParameters().size() > 0 ? 1 : 0) != 0);
        List<Slice> params = command.getParameters();
        List<Slice> commandParams = params.subList(1, params.size());
        String name = new String(params.get(0).data(), StandardCharsets.UTF_8).toLowerCase(Locale.ROOT);
        try {
            if (name.equals("multi")) {
                this.newTransaction();
                return Response.clientResponse(name, Response.OK);
            }
            RedisOperation redisOperation = this.buildSimpleOperation(name, commandParams);
            if (!this.transactionModeOn) {
                return Response.clientResponse(name, redisOperation.execute());
            }
            this.transaction.add(redisOperation);
            return Response.clientResponse(name, Response.OK);
        }
        catch (WrongValueTypeException | UnsupportedOperationException e) {
            LOG.error("Malformed request", (Throwable)e);
            return Response.error(e.getMessage());
        }
        catch (WrongNumberOfArgumentsException e) {
            LOG.error("Malformed request", (Throwable)e);
            return Response.error(String.format("ERR wrong number of arguments for '%s' command", name));
        }
    }

    private void newTransaction() {
        if (this.transactionModeOn) {
            throw new RuntimeException("Redis mock does not support more than one transaction");
        }
        this.transactionModeOn = true;
    }
}

