/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.redismock.commands;

import ai.grakn.redismock.RedisBase;
import ai.grakn.redismock.Response;
import ai.grakn.redismock.Slice;
import ai.grakn.redismock.Utils;
import ai.grakn.redismock.commands.AbstractRedisOperation;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class RO_lrem
extends AbstractRedisOperation {
    RO_lrem(RedisBase base, List<Slice> params) {
        super(base, params, 3, null, null);
    }

    @Override
    Slice response() {
        Slice key = this.params().get(0);
        int numRemove = Utils.convertToInteger(new String(this.params().get(1).data(), StandardCharsets.UTF_8));
        Slice target = this.params().get(2);
        Slice data = this.base().rawGet(key);
        if (data == null) {
            return Response.integer(0L);
        }
        LinkedList list = (LinkedList)Utils.deserializeObject(data);
        int numRemoved = 0;
        Iterator iterator = numRemove < 0 ? list.descendingIterator() : list.iterator();
        numRemove = Math.abs(numRemove);
        while (iterator.hasNext()) {
            Slice element = (Slice)iterator.next();
            if (!element.equals(target) || numRemove != 0 && numRemoved >= numRemove) continue;
            iterator.remove();
            ++numRemoved;
        }
        this.base().rawPut(key, Utils.serializeObject(list), -1L);
        return Response.integer(numRemoved);
    }
}

