/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.tensorflow.zoo.cv.objectdetction;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.output.Rectangle;
import ai.djl.modality.cv.translator.ObjectDetectionTranslator;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.translate.Batchifier;
import ai.djl.translate.TranslatorContext;
import java.util.ArrayList;
import java.util.Map;

public class TfSsdTranslator
extends ObjectDetectionTranslator {
    private int maxBoxes;
    private String boundingBoxOutputName;
    private String scoresOutputName;
    private String classLabelOutputName;

    protected TfSsdTranslator(Builder builder) {
        super((ObjectDetectionTranslator.ObjectDetectionBuilder)builder);
        this.maxBoxes = builder.maxBoxes;
        this.boundingBoxOutputName = builder.boundingBoxOutputName;
        this.scoresOutputName = builder.scoresOutputName;
        this.classLabelOutputName = builder.classLabelOutputName;
    }

    public NDList processInput(TranslatorContext ctx, Image input) {
        return new NDList(new NDArray[]{((NDArray)super.processInput(ctx, input).get(0)).expandDims(0)});
    }

    public Batchifier getBatchifier() {
        return null;
    }

    public DetectedObjects processOutput(TranslatorContext ctx, NDList list) {
        int len = (int)((NDArray)list.get(0)).getShape().get(0);
        float[] scores = new float[len];
        long[] classIds = new long[len];
        NDArray boundingBoxes = (NDArray)list.get(0);
        for (NDArray array : list) {
            if (this.scoresOutputName.equals(array.getName())) {
                scores = array.toFloatArray();
                continue;
            }
            if (this.boundingBoxOutputName.equals(array.getName())) {
                boundingBoxes = array;
                continue;
            }
            if (this.classLabelOutputName.equals(array.getName())) {
                classIds = array.toLongArray();
                continue;
            }
            throw new IllegalStateException("Unexpected result NDArray:" + array.getName());
        }
        ArrayList<String> retNames = new ArrayList<String>();
        ArrayList<Double> retProbs = new ArrayList<Double>();
        ArrayList<Rectangle> retBB = new ArrayList<Rectangle>();
        for (int i = 0; i < Math.min(classIds.length, this.maxBoxes); ++i) {
            long classId = classIds[i];
            double score = scores[i];
            if (classId < 0L || !(score > (double)this.threshold)) continue;
            if (classId >= (long)this.classes.size()) {
                throw new AssertionError((Object)("Unexpected index: " + classId));
            }
            String className = (String)this.classes.get((int)classId - 1);
            float[] box = boundingBoxes.get(new long[]{i}).toFloatArray();
            float yMin = box[0];
            float xMin = box[1];
            float yMax = box[2];
            float xMax = box[3];
            double w = xMax - xMin;
            double h = yMax - yMin;
            Rectangle rect = new Rectangle((double)xMin, (double)yMin, w, h);
            retNames.add(className);
            retProbs.add(score);
            retBB.add(rect);
        }
        return new DetectedObjects(retNames, retProbs, retBB);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Map<String, Object> arguments) {
        Builder builder = new Builder();
        builder.configPreProcess(arguments);
        builder.configPostProcess(arguments);
        return builder;
    }

    public static class Builder
    extends ObjectDetectionTranslator.ObjectDetectionBuilder<Builder> {
        private int maxBoxes = 10;
        private String boundingBoxOutputName = "detection_boxes";
        private String scoresOutputName = "detection_scores";
        private String classLabelOutputName = "detection_class_labels";

        public Builder optBoundingBoxOutputName(String boundingBoxOutputName) {
            this.boundingBoxOutputName = boundingBoxOutputName;
            return this;
        }

        public Builder optScoresOutputName(String scoresOutputName) {
            this.scoresOutputName = scoresOutputName;
            return this;
        }

        public Builder optClassLabelOutputName(String classLabelOutputName) {
            this.classLabelOutputName = classLabelOutputName;
            return this;
        }

        public Builder optMaxBoxes(int maxBoxes) {
            this.maxBoxes = maxBoxes;
            return this;
        }

        protected Builder self() {
            return this;
        }

        protected void configPreProcess(Map<String, Object> arguments) {
            super.configPreProcess(arguments);
        }

        protected void configPostProcess(Map<String, Object> arguments) {
            super.configPostProcess(arguments);
            this.maxBoxes = TfSsdTranslator.getIntValue((Map)arguments, (String)"maxBoxes", (int)10);
            this.threshold = TfSsdTranslator.getFloatValue((Map)arguments, (String)"threshold", (float)0.4f);
            this.boundingBoxOutputName = (String)arguments.getOrDefault("boundingBoxOutputName", "detection_boxes");
            this.scoresOutputName = (String)arguments.getOrDefault("scoresOutputName", "detection_scores");
            this.classLabelOutputName = (String)arguments.getOrDefault("classLabelOutputName", "detection_class_labels");
        }

        public TfSsdTranslator build() {
            this.validate();
            return new TfSsdTranslator(this);
        }
    }
}

