/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.tensorflow.engine;

import ai.djl.Device;
import ai.djl.Model;
import ai.djl.engine.Engine;
import ai.djl.ndarray.NDManager;
import ai.djl.tensorflow.engine.LibUtils;
import ai.djl.tensorflow.engine.TfModel;
import ai.djl.tensorflow.engine.TfNDManager;
import ai.djl.training.GradientCollector;
import ai.djl.util.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.EagerSession;
import org.tensorflow.TensorFlow;

public final class TfEngine
extends Engine {
    private static final Logger logger = LoggerFactory.getLogger(TfEngine.class);
    public static final String ENGINE_NAME = "TensorFlow";

    private TfEngine() {
    }

    static TfEngine newInstance() {
        try {
            LibUtils.loadLibrary();
            EagerSession.getDefault();
            return new TfEngine();
        }
        catch (Throwable e) {
            logger.warn("Failed load TensorFlow native library.", e);
            return null;
        }
    }

    public Model newModel(Device device) {
        return new TfModel(device);
    }

    public String getEngineName() {
        return ENGINE_NAME;
    }

    public String getVersion() {
        return TensorFlow.version();
    }

    public boolean hasCapability(String capability) {
        if ("MKL".equals(capability)) {
            return true;
        }
        if ("CUDA".equals(capability)) {
            return Platform.fromSystem().getCudaArch() != null;
        }
        return false;
    }

    public NDManager newBaseManager() {
        return TfNDManager.getSystemManager().newSubManager();
    }

    public NDManager newBaseManager(Device device) {
        return TfNDManager.getSystemManager().newSubManager(device);
    }

    public GradientCollector newGradientCollector() {
        throw new UnsupportedOperationException("TensorFlow does not support training yet");
    }

    public void setRandomSeed(int seed) {
        TfNDManager.setRandomSeed(seed);
    }
}

