/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.tensorflow.engine;

import ai.djl.ndarray.types.DataType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TfDataType {
    private static Map<DataType, Integer> toTfMap = TfDataType.createToTfMap();
    private static Map<Integer, DataType> fromTfMap = TfDataType.createFromTfMap();

    private TfDataType() {
    }

    private static Map<DataType, Integer> createToTfMap() {
        ConcurrentHashMap<DataType, Integer> map = new ConcurrentHashMap<DataType, Integer>();
        map.put(DataType.FLOAT32, 1);
        map.put(DataType.FLOAT64, 2);
        map.put(DataType.INT32, 3);
        map.put(DataType.INT64, 9);
        map.put(DataType.UINT8, 4);
        map.put(DataType.INT8, 6);
        map.put(DataType.BOOLEAN, 10);
        map.put(DataType.STRING, 7);
        return map;
    }

    private static Map<Integer, DataType> createFromTfMap() {
        ConcurrentHashMap<Integer, DataType> map = new ConcurrentHashMap<Integer, DataType>();
        map.put(1, DataType.FLOAT32);
        map.put(2, DataType.FLOAT64);
        map.put(3, DataType.INT32);
        map.put(4, DataType.UINT8);
        map.put(6, DataType.INT8);
        map.put(7, DataType.STRING);
        map.put(9, DataType.INT64);
        map.put(10, DataType.BOOLEAN);
        return map;
    }

    public static int toTf(DataType dataType) {
        Integer tfType = toTfMap.get(dataType);
        if (tfType == null) {
            throw new UnsupportedOperationException("Unsupported data type: " + dataType);
        }
        return tfType;
    }

    public static DataType fromTf(int dataType) {
        return fromTfMap.get(dataType);
    }
}

