/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.types;

import java.util.function.Consumer;
import org.tensorflow.DataType;
import org.tensorflow.Tensor;
import org.tensorflow.ndarray.FloatNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.StdArrays;
import org.tensorflow.ndarray.buffer.FloatDataBuffer;
import org.tensorflow.types.TFloat16Impl;
import org.tensorflow.types.family.TNumber;

public interface TFloat16
extends FloatNdArray,
TNumber {
    public static final String NAME = "FLOAT16";
    public static final DataType<TFloat16> DTYPE = DataType.create("FLOAT16", 19, 2, TFloat16Impl::mapTensor);

    public static Tensor<TFloat16> scalarOf(float value) {
        return Tensor.of(DTYPE, Shape.scalar(), data -> data.setFloat(value, new long[0]));
    }

    public static Tensor<TFloat16> vectorOf(float ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        return Tensor.of(DTYPE, Shape.of(values.length), data -> StdArrays.copyTo(values, (FloatNdArray)data));
    }

    public static Tensor<TFloat16> tensorOf(NdArray<Float> src) {
        return Tensor.of(DTYPE, src.shape(), src::copyTo);
    }

    public static Tensor<TFloat16> tensorOf(Shape shape) {
        return Tensor.of(DTYPE, shape);
    }

    public static Tensor<TFloat16> tensorOf(Shape shape, FloatDataBuffer data) {
        return Tensor.of(DTYPE, shape, d -> d.write(data));
    }

    public static Tensor<TFloat16> tensorOf(Shape shape, Consumer<TFloat16> dataInit) {
        return Tensor.of(DTYPE, shape, dataInit);
    }
}

