/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg.sparse;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class SparseMatrixSparseMatMul
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "SparseMatrixSparseMatMul";
    private Output<?> c;

    public static <T extends TType> SparseMatrixSparseMatMul create(Scope scope, Operand<?> a, Operand<?> b, DataType<T> type, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(a.asOutput());
        opBuilder.addInput(b.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("type", type);
        if (options != null) {
            for (Options opts : options) {
                if (opts.transposeA != null) {
                    opBuilder.setAttr("transpose_a", opts.transposeA);
                }
                if (opts.transposeB != null) {
                    opBuilder.setAttr("transpose_b", opts.transposeB);
                }
                if (opts.adjointA != null) {
                    opBuilder.setAttr("adjoint_a", opts.adjointA);
                }
                if (opts.adjointB == null) continue;
                opBuilder.setAttr("adjoint_b", opts.adjointB);
            }
        }
        return new SparseMatrixSparseMatMul(opBuilder.build());
    }

    public static Options transposeA(Boolean transposeA) {
        return new Options().transposeA(transposeA);
    }

    public static Options transposeB(Boolean transposeB) {
        return new Options().transposeB(transposeB);
    }

    public static Options adjointA(Boolean adjointA) {
        return new Options().adjointA(adjointA);
    }

    public static Options adjointB(Boolean adjointB) {
        return new Options().adjointB(adjointB);
    }

    public Output<?> c() {
        return this.c;
    }

    @Override
    public Output<TType> asOutput() {
        return this.c;
    }

    private SparseMatrixSparseMatMul(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.c = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean transposeA;
        private Boolean transposeB;
        private Boolean adjointA;
        private Boolean adjointB;

        public Options transposeA(Boolean transposeA) {
            this.transposeA = transposeA;
            return this;
        }

        public Options transposeB(Boolean transposeB) {
            this.transposeB = transposeB;
            return this;
        }

        public Options adjointA(Boolean adjointA) {
            this.adjointA = adjointA;
            return this;
        }

        public Options adjointB(Boolean adjointB) {
            this.adjointB = adjointB;
            return this;
        }

        private Options() {
        }
    }
}

