/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;

public final class ParseExample
extends RawOp {
    public static final String OP_NAME = "ParseExampleV2";
    private List<Output<TInt64>> sparseIndices;
    private List<Output<?>> sparseValues;
    private List<Output<TInt64>> sparseShapes;
    private List<Output<?>> denseValues;
    private List<Output<?>> raggedValues;
    private List<Output<?>> raggedRowSplits;

    public static ParseExample create(Scope scope, Operand<TString> serialized, Operand<TString> names, Operand<TString> sparseKeys, Operand<TString> denseKeys, Operand<TString> raggedKeys, Iterable<Operand<?>> denseDefaults, Long numSparse, List<DataType<?>> sparseTypes, List<DataType<?>> raggedValueTypes, List<DataType<?>> raggedSplitTypes, List<Shape> denseShapes) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("ParseExample"));
        opBuilder.addInput(serialized.asOutput());
        opBuilder.addInput(names.asOutput());
        opBuilder.addInput(sparseKeys.asOutput());
        opBuilder.addInput(denseKeys.asOutput());
        opBuilder.addInput(raggedKeys.asOutput());
        opBuilder.addInputList(Operands.asOutputs(denseDefaults));
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("num_sparse", numSparse);
        DataType[] sparseTypesArray = new DataType[sparseTypes.size()];
        for (int i = 0; i < sparseTypesArray.length; ++i) {
            sparseTypesArray[i] = sparseTypes.get(i);
        }
        opBuilder.setAttr("sparse_types", sparseTypesArray);
        DataType[] raggedValueTypesArray = new DataType[raggedValueTypes.size()];
        for (int i = 0; i < raggedValueTypesArray.length; ++i) {
            raggedValueTypesArray[i] = raggedValueTypes.get(i);
        }
        opBuilder.setAttr("ragged_value_types", raggedValueTypesArray);
        DataType[] raggedSplitTypesArray = new DataType[raggedSplitTypes.size()];
        for (int i = 0; i < raggedSplitTypesArray.length; ++i) {
            raggedSplitTypesArray[i] = raggedSplitTypes.get(i);
        }
        opBuilder.setAttr("ragged_split_types", raggedSplitTypesArray);
        Shape[] denseShapesArray = new Shape[denseShapes.size()];
        for (int i = 0; i < denseShapesArray.length; ++i) {
            denseShapesArray[i] = denseShapes.get(i);
        }
        opBuilder.setAttr("dense_shapes", denseShapesArray);
        return new ParseExample(opBuilder.build());
    }

    public List<Output<TInt64>> sparseIndices() {
        return this.sparseIndices;
    }

    public List<Output<?>> sparseValues() {
        return this.sparseValues;
    }

    public List<Output<TInt64>> sparseShapes() {
        return this.sparseShapes;
    }

    public List<Output<?>> denseValues() {
        return this.denseValues;
    }

    public List<Output<?>> raggedValues() {
        return this.raggedValues;
    }

    public List<Output<?>> raggedRowSplits() {
        return this.raggedRowSplits;
    }

    private ParseExample(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int sparseIndicesLength = operation.outputListLength("sparse_indices");
        this.sparseIndices = Arrays.asList(operation.outputList(outputIdx, sparseIndicesLength));
        int sparseValuesLength = operation.outputListLength("sparse_values");
        this.sparseValues = Arrays.asList(operation.outputList(outputIdx += sparseIndicesLength, sparseValuesLength));
        int sparseShapesLength = operation.outputListLength("sparse_shapes");
        this.sparseShapes = Arrays.asList(operation.outputList(outputIdx += sparseValuesLength, sparseShapesLength));
        int denseValuesLength = operation.outputListLength("dense_values");
        this.denseValues = Arrays.asList(operation.outputList(outputIdx += sparseShapesLength, denseValuesLength));
        int raggedValuesLength = operation.outputListLength("ragged_values");
        this.raggedValues = Arrays.asList(operation.outputList(outputIdx += denseValuesLength, raggedValuesLength));
        int raggedRowSplitsLength = operation.outputListLength("ragged_row_splits");
        this.raggedRowSplits = Arrays.asList(operation.outputList(outputIdx += raggedValuesLength, raggedRowSplitsLength));
        outputIdx += raggedRowSplitsLength;
    }
}

