/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

public final class NonMaxSuppression<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "NonMaxSuppressionV5";
    private Output<TInt32> selectedIndices;
    private Output<T> selectedScores;
    private Output<TInt32> validOutputs;

    public static <T extends TNumber> NonMaxSuppression<T> create(Scope scope, Operand<T> boxes, Operand<T> scores, Operand<TInt32> maxOutputSize, Operand<T> iouThreshold, Operand<T> scoreThreshold, Operand<T> softNmsSigma, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("NonMaxSuppression"));
        opBuilder.addInput(boxes.asOutput());
        opBuilder.addInput(scores.asOutput());
        opBuilder.addInput(maxOutputSize.asOutput());
        opBuilder.addInput(iouThreshold.asOutput());
        opBuilder.addInput(scoreThreshold.asOutput());
        opBuilder.addInput(softNmsSigma.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.padToMaxOutputSize == null) continue;
                opBuilder.setAttr("pad_to_max_output_size", opts.padToMaxOutputSize);
            }
        }
        return new NonMaxSuppression<T>(opBuilder.build());
    }

    public static Options padToMaxOutputSize(Boolean padToMaxOutputSize) {
        return new Options().padToMaxOutputSize(padToMaxOutputSize);
    }

    public Output<TInt32> selectedIndices() {
        return this.selectedIndices;
    }

    public Output<T> selectedScores() {
        return this.selectedScores;
    }

    public Output<TInt32> validOutputs() {
        return this.validOutputs;
    }

    private NonMaxSuppression(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.selectedIndices = operation.output(outputIdx++);
        this.selectedScores = operation.output(outputIdx++);
        this.validOutputs = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean padToMaxOutputSize;

        public Options padToMaxOutputSize(Boolean padToMaxOutputSize) {
            this.padToMaxOutputSize = padToMaxOutputSize;
            return this;
        }

        private Options() {
        }
    }
}

