/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

public final class DynamicPartition<T extends TType>
extends RawOp
implements Iterable<Operand<T>> {
    public static final String OP_NAME = "DynamicPartition";
    private List<Output<T>> outputs;

    public static <T extends TType> DynamicPartition<T> create(Scope scope, Operand<T> data, Operand<TInt32> partitions, Long numPartitions) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(data.asOutput());
        opBuilder.addInput(partitions.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("num_partitions", numPartitions);
        return new DynamicPartition<T>(opBuilder.build());
    }

    public List<Output<T>> outputs() {
        return this.outputs;
    }

    @Override
    public Iterator<Operand<T>> iterator() {
        return this.outputs.iterator();
    }

    private DynamicPartition(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int outputsLength = operation.outputListLength("outputs");
        this.outputs = Arrays.asList(operation.outputList(outputIdx, outputsLength));
        outputIdx += outputsLength;
    }
}

