/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerScope;
import org.bytedeco.javacpp.SizeTPointer;
import org.tensorflow.ExecutionEnvironment;
import org.tensorflow.GraphOperation;
import org.tensorflow.GraphOperationBuilder;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.Output;
import org.tensorflow.TensorFlow;
import org.tensorflow.exceptions.TensorFlowException;
import org.tensorflow.internal.c_api.TF_Buffer;
import org.tensorflow.internal.c_api.TF_Graph;
import org.tensorflow.internal.c_api.TF_ImportGraphDefOptions;
import org.tensorflow.internal.c_api.TF_Operation;
import org.tensorflow.internal.c_api.TF_Output;
import org.tensorflow.internal.c_api.TF_Status;
import org.tensorflow.internal.c_api.TF_WhileParams;
import org.tensorflow.internal.c_api.global.tensorflow;
import org.tensorflow.ndarray.StdArrays;
import org.tensorflow.op.Op;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.Assign;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.core.NoOp;
import org.tensorflow.op.core.Placeholder;
import org.tensorflow.op.core.ZerosLike;
import org.tensorflow.op.train.Restore;
import org.tensorflow.op.train.Save;
import org.tensorflow.proto.framework.GraphDef;
import org.tensorflow.proto.util.SaverDef;
import org.tensorflow.types.TString;

public final class Graph
implements ExecutionEnvironment,
AutoCloseable {
    private final Object nativeHandleLock = new Object();
    private TF_Graph nativeHandle;
    private int refcount = 0;
    private SaverDef saverDef;
    private final List<Op> initializers = new ArrayList<Op>();

    public Graph() {
        this.nativeHandle = Graph.allocate();
    }

    Graph(TF_Graph nativeHandle) {
        this.nativeHandle = nativeHandle;
    }

    Graph(TF_Graph nativeHandle, SaverDef saverDef) {
        this(nativeHandle);
        this.saverDef = saverDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.nativeHandleLock;
        synchronized (object) {
            if (this.nativeHandle == null || this.nativeHandle.isNull()) {
                return;
            }
            while (this.refcount > 0) {
                try {
                    this.nativeHandleLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            Graph.delete(this.nativeHandle);
            this.nativeHandle = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphOperation operation(String name) {
        Object object = this.nativeHandleLock;
        synchronized (object) {
            TF_Operation oph = Graph.operation(this.nativeHandle, name);
            if (oph == null || oph.isNull()) {
                return null;
            }
            return new GraphOperation(this, oph);
        }
    }

    public Iterator<Operation> operations() {
        return new OperationIterator(this);
    }

    @Override
    public GraphOperationBuilder opBuilder(String type, String name) {
        return new GraphOperationBuilder(this, type, name);
    }

    @Override
    public ExecutionEnvironment.Types environmentType() {
        return ExecutionEnvironment.Types.GRAPH;
    }

    public void importGraphDef(GraphDef graphDef) throws IllegalArgumentException {
        this.importGraphDef(graphDef, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importGraphDef(GraphDef graphDef, String prefix) throws IllegalArgumentException {
        if (graphDef == null || prefix == null) {
            throw new IllegalArgumentException("graphDef and prefix cannot be null");
        }
        Object object = this.nativeHandleLock;
        synchronized (object) {
            Graph.importGraphDef(this.nativeHandle, graphDef, prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphDef toGraphDef() {
        Object object = this.nativeHandleLock;
        synchronized (object) {
            return Graph.toGraphDef(this.nativeHandle);
        }
    }

    public synchronized void addInitializer(Op initializer) {
        this.initializers.add(initializer);
    }

    public List<Op> initializers() {
        return Collections.unmodifiableList(this.initializers);
    }

    public Output<?>[] addGradients(String prefix, Output<?>[] y, Output<?>[] x, Output<?>[] dx) {
        Output[] dy = new Output[x.length];
        TF_Operation[] yHandles = new TF_Operation[y.length];
        int[] yIndices = new int[y.length];
        TF_Operation[] xHandles = new TF_Operation[x.length];
        int[] xIndices = new int[x.length];
        TF_Operation[] dxHandles = null;
        int[] dxIndices = null;
        try (Reference ref = this.ref();){
            Object[] dyHandlesAndIndices;
            int ndy;
            int i;
            for (i = 0; i < y.length; ++i) {
                yHandles[i] = (TF_Operation)y[i].getUnsafeNativeHandle();
                yIndices[i] = y[i].index();
            }
            for (i = 0; i < x.length; ++i) {
                xHandles[i] = (TF_Operation)x[i].getUnsafeNativeHandle();
                xIndices[i] = x[i].index();
            }
            if (dx != null && dx.length > 0) {
                dxHandles = new TF_Operation[dx.length];
                dxIndices = new int[dx.length];
                for (i = 0; i < dx.length; ++i) {
                    dxHandles[i] = (TF_Operation)dx[i].getUnsafeNativeHandle();
                    dxIndices[i] = dx[i].index();
                }
            }
            if ((ndy = (dyHandlesAndIndices = Graph.addGradients(ref.nativeHandle(), prefix, yHandles, yIndices, xHandles, xIndices, dxHandles, dxIndices)).length >> 1) != dy.length) {
                throw new IllegalStateException(String.valueOf(ndy) + " gradients were added to the graph when " + dy.length + " were expected");
            }
            int i2 = 0;
            int j = ndy;
            while (i2 < ndy) {
                GraphOperation op = new GraphOperation(this, (TF_Operation)((Object)dyHandlesAndIndices[i2]));
                dy[i2] = new Output(op, (Integer)dyHandlesAndIndices[j]);
                ++i2;
                ++j;
            }
        }
        return dy;
    }

    public Output<?>[] addGradients(Output<?> y, Output<?>[] x) {
        return this.addGradients(null, new Output[]{y}, x, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] buildSubgraph(WhileSubgraphBuilder subgraphBuilder, TF_Graph subgraphHandle, TF_Operation[] inputHandles, int[] inputIndices, TF_Operation[] outputHandles, int[] outputIndices) {
        Graph subgraph = new Graph(subgraphHandle);
        int ninputs = inputHandles.length;
        int noutputs = outputHandles.length;
        Output[] inputs = new Output[ninputs];
        Output[] outputs = new Output[noutputs];
        Object[] outputHandlesAndIndices = new Object[noutputs * 2];
        Object object = subgraph.nativeHandleLock;
        synchronized (object) {
            try (Reference ref = subgraph.ref();){
                GraphOperation op;
                int i;
                for (i = 0; i < ninputs; ++i) {
                    op = new GraphOperation(subgraph, inputHandles[i]);
                    inputs[i] = op.output(inputIndices[i]);
                }
                for (i = 0; i < noutputs; ++i) {
                    op = new GraphOperation(subgraph, outputHandles[i]);
                    outputs[i] = op.output(outputIndices[i]);
                }
                subgraphBuilder.buildSubgraph(subgraph, inputs, outputs);
                i = 0;
                int j = noutputs;
                while (i < noutputs) {
                    outputHandlesAndIndices[i] = outputs[i].getUnsafeNativeHandle();
                    outputHandlesAndIndices[j] = outputs[i].index();
                    ++i;
                    ++j;
                }
            }
            return outputHandlesAndIndices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Output<?>[] whileLoop(Output<?>[] inputs, WhileSubgraphBuilder cgBuilder, WhileSubgraphBuilder bgBuilder, String name) {
        int ninputs = inputs.length;
        TF_Operation[] inputHandles = new TF_Operation[ninputs];
        int[] inputIndices = new int[ninputs];
        Output[] outputs = new Output[ninputs];
        Object object = this.nativeHandleLock;
        synchronized (object) {
            try (Reference ref = this.ref();){
                for (int i = 0; i < ninputs; ++i) {
                    inputHandles[i] = (TF_Operation)inputs[i].getUnsafeNativeHandle();
                    inputIndices[i] = inputs[i].index();
                }
                Object[] outputHandlesAndIndices = Graph.whileLoop(this.nativeHandle, inputHandles, inputIndices, name, cgBuilder, bgBuilder);
                int i = 0;
                int j = ninputs;
                while (i < ninputs) {
                    GraphOperation op = new GraphOperation(this, (TF_Operation)((Object)outputHandlesAndIndices[i]));
                    outputs[i] = op.output((Integer)outputHandlesAndIndices[j]);
                    ++i;
                    ++j;
                }
            }
            return outputs;
        }
    }

    synchronized SaverDef saverDef() {
        if (this.saverDef == null) {
            this.saverDef = Graph.addVariableSaver(this);
        }
        return this.saverDef;
    }

    Reference ref() {
        return new Reference();
    }

    private static TF_Graph allocate() {
        return tensorflow.TF_NewGraph();
    }

    private static void delete(TF_Graph handle) {
        if (handle == null || handle.isNull()) {
            return;
        }
        tensorflow.TF_DeleteGraph(handle);
    }

    private static void requireHandle(Pointer handle) {
        if (handle == null || handle.isNull()) {
            throw new IllegalStateException("close() has been called on the Graph");
        }
    }

    private static TF_Operation operation(TF_Graph handle, String name) {
        Graph.requireHandle(handle);
        return tensorflow.TF_GraphOperationByName(handle, name);
    }

    private static Object[] nextOperation(TF_Graph handle, int position) {
        Graph.requireHandle(handle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            SizeTPointer pos = new SizeTPointer(1L).put((long)position);
            TF_Operation operation = tensorflow.TF_GraphNextOperation(handle, pos);
            if (operation == null || operation.isNull()) {
                Object[] objectArray = null;
                return objectArray;
            }
            Object[] handleAndPosition = new Object[]{operation, (int)pos.get()};
            Object[] objectArray = handleAndPosition;
            return objectArray;
        }
    }

    private static void importGraphDef(TF_Graph handle, GraphDef graphDef, String prefix) throws IllegalArgumentException {
        Graph.requireHandle(handle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_ImportGraphDefOptions opts = TF_ImportGraphDefOptions.newImportGraphDefOptions();
            tensorflow.TF_ImportGraphDefOptionsSetPrefix(opts, prefix);
            TF_Buffer buf = TF_Buffer.newBufferFromString((Message)graphDef);
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_GraphImportGraphDef(handle, buf, opts, status);
            status.throwExceptionIfNotOK();
        }
    }

    private static GraphDef toGraphDef(TF_Graph handle) {
        Graph.requireHandle(handle);
        Throwable throwable = null;
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Buffer buf = TF_Buffer.newBuffer();
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_GraphToGraphDef(handle, buf, status);
            status.throwExceptionIfNotOK();
            try {
                GraphDef graphDef = GraphDef.parseFrom(buf.dataAsByteBuffer());
                return graphDef;
            }
            catch (InvalidProtocolBufferException e) {
                try {
                    throw new TensorFlowException("Cannot parse GraphDef protocol buffer", e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    static void resolveOutputs(String type, TF_Operation[] srcOps, int[] srcIndices, TF_Output dst, int n) {
        if (srcOps.length != n) {
            throw new IllegalArgumentException("expected " + n + ", got " + srcOps.length + " " + type + " Operations");
        }
        if (srcIndices.length != n) {
            throw new IllegalArgumentException("expected " + n + ", got " + srcIndices.length + " " + type + " Operation output indices");
        }
        for (int i = 0; i < n; ++i) {
            if (srcOps[i] == null || srcOps[i].isNull()) {
                throw new IllegalStateException("invalid " + type + " (#" + i + " of " + n + ")");
            }
            dst.position(i).oper(srcOps[i]).index(srcIndices[i]);
        }
        dst.position(0L);
    }

    private static Object[] addGradients(TF_Graph handle, String prefix, TF_Operation[] inputHandles, int[] inputIndices, TF_Operation[] outputHandles, int[] outputIndices, TF_Operation[] gradInputHandles, int[] gradInputIndices) {
        Graph.requireHandle(handle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            int ny = inputHandles.length;
            int nx = outputHandles.length;
            TF_Output y = new TF_Output(ny);
            TF_Output x = new TF_Output(nx);
            TF_Output dx = null;
            TF_Output dy = new TF_Output(nx);
            Graph.resolveOutputs("y", inputHandles, inputIndices, y, ny);
            Graph.resolveOutputs("x", outputHandles, outputIndices, x, nx);
            if (gradInputHandles != null) {
                if (gradInputHandles.length != ny) {
                    throw new IllegalArgumentException("expected " + ny + ", got " + gradInputHandles.length + " handles");
                }
                dx = new TF_Output(ny);
                Graph.resolveOutputs("dx", gradInputHandles, gradInputIndices, dx, ny);
            }
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_AddGradientsWithPrefix(handle, prefix, y, ny, x, nx, dx, status, dy);
            status.throwExceptionIfNotOK();
            Object[] gradOutputHandlesAndIndices = new Object[nx * 2];
            int i = 0;
            int j = nx;
            while (i < nx) {
                TF_Output gradOutput = dy.position(i);
                gradOutputHandlesAndIndices[i] = gradOutput.oper();
                gradOutputHandlesAndIndices[j] = gradOutput.index();
                ++i;
                ++j;
            }
            Object[] objectArray = gradOutputHandlesAndIndices;
            return objectArray;
        }
    }

    private static Object[] whileLoop(TF_Graph handle, TF_Operation[] inputHandles, int[] inputIndices, String name, WhileSubgraphBuilder condGraphBuilder, WhileSubgraphBuilder bodyGraphBuilder) {
        Graph.requireHandle(handle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Status status = TF_Status.newStatus();
            int ninputs = inputHandles.length;
            TF_Output inputs = new TF_Output(ninputs);
            Graph.resolveOutputs("inputs", inputHandles, inputIndices, inputs, ninputs);
            TF_WhileParams params = tensorflow.TF_NewWhile(handle, inputs, ninputs, status);
            status.throwExceptionIfNotOK();
            TF_Output condInputsOutput = params.cond_inputs();
            TF_Output condOutputOutput = params.cond_output();
            TF_Operation[] condInputHandles = new TF_Operation[ninputs];
            int[] condInputIndices = new int[ninputs];
            TF_Operation[] condOutputHandles = new TF_Operation[1];
            int[] condOutputIndices = new int[1];
            for (int i = 0; i < ninputs; ++i) {
                condInputHandles[i] = condInputsOutput.position(i).oper();
                condInputIndices[i] = condInputsOutput.position(i).index();
            }
            condOutputHandles[0] = condOutputOutput.oper();
            condOutputIndices[0] = condOutputOutput.index();
            Object[] condOutputHandlesAndIndices = Graph.buildSubgraph(condGraphBuilder, params.cond_graph(), condInputHandles, condInputIndices, condOutputHandles, condOutputIndices);
            TF_Output bodyInputsOutput = params.body_inputs();
            TF_Output bodyOutputsOutput = params.body_outputs();
            TF_Operation[] bodyInputHandles = new TF_Operation[ninputs];
            int[] bodyInputIndices = new int[ninputs];
            TF_Operation[] bodyOutputHandles = new TF_Operation[ninputs];
            int[] bodyOutputIndices = new int[ninputs];
            for (int i = 0; i < ninputs; ++i) {
                bodyInputHandles[i] = bodyInputsOutput.position(i).oper();
                bodyInputIndices[i] = bodyInputsOutput.position(i).index();
                bodyOutputHandles[i] = bodyOutputsOutput.position(i).oper();
                bodyOutputIndices[i] = bodyOutputsOutput.position(i).index();
            }
            Object[] bodyOutputHandlesAndIndices = Graph.buildSubgraph(bodyGraphBuilder, params.body_graph(), bodyInputHandles, bodyInputIndices, bodyOutputHandles, bodyOutputIndices);
            if (condOutputHandlesAndIndices == null || bodyOutputHandlesAndIndices == null) {
                Object[] objectArray = null;
                return objectArray;
            }
            condOutputOutput.oper((TF_Operation)((Object)condOutputHandlesAndIndices[0])).index((Integer)condOutputHandlesAndIndices[1]);
            int i = 0;
            int j = ninputs;
            while (i < ninputs) {
                bodyOutputsOutput.position(i).oper((TF_Operation)((Object)bodyOutputHandlesAndIndices[i])).index((Integer)bodyOutputHandlesAndIndices[j]);
                ++i;
                ++j;
            }
            params.name(new BytePointer(name));
            TF_Output outputs = new TF_Output(ninputs);
            tensorflow.TF_FinishWhile(params, status, outputs);
            status.throwExceptionIfNotOK();
            Object[] outputHandlesAndIndices = new Object[ninputs * 2];
            int i2 = 0;
            int j2 = ninputs;
            while (i2 < ninputs) {
                TF_Output output = outputs.position(i2);
                outputHandlesAndIndices[i2] = output.oper();
                outputHandlesAndIndices[j2] = output.index();
                ++i2;
                ++j2;
            }
            Object[] objectArray = outputHandlesAndIndices;
            return objectArray;
        }
    }

    private static SaverDef addVariableSaver(Graph graph) {
        Ops tf = Ops.create(graph).withSubScope("save");
        ArrayList<String> varNames = new ArrayList<String>();
        ArrayList varOutputs = new ArrayList();
        ArrayList varTypes = new ArrayList();
        Iterator<Operation> iter = graph.operations();
        while (iter.hasNext()) {
            Operation op = iter.next();
            if (!op.type().equals("VariableV2")) continue;
            varNames.add(op.name());
            varOutputs.add(op.output(0));
            varTypes.add(op.output(0).dataType());
        }
        String[] tmp = new String[varNames.size()];
        Constant<TString> varNamesTensor = tf.constant(StdArrays.ndCopyOf(varNames.toArray(tmp)));
        ZerosLike<TString> varSlices = tf.zerosLike(varNamesTensor);
        Placeholder<TString> saveFilename = tf.placeholder(TString.DTYPE, new Placeholder.Options[0]);
        Save saveVariables = tf.train.save(saveFilename, varNamesTensor, varSlices, varOutputs);
        Restore restoreVariables = tf.train.restore(saveFilename, varNamesTensor, varSlices, varTypes);
        ArrayList<Op> restoreOps = new ArrayList<Op>(varOutputs.size());
        for (int i = 0; i < varOutputs.size(); ++i) {
            restoreOps.add(tf.assign((Operand)varOutputs.get(i), restoreVariables.tensors().get(i), new Assign.Options[0]));
        }
        NoOp restoreAll = tf.withControlDependencies(restoreOps).noOp();
        return SaverDef.newBuilder().setFilenameTensorName(saveFilename.op().name()).setSaveTensorName(saveVariables.op().name()).setRestoreOpName(restoreAll.op().name()).build();
    }

    static {
        TensorFlow.init();
    }

    private static final class OperationIterator
    implements Iterator<Operation> {
        private final Graph graph;
        private Operation operation;
        private int position;

        OperationIterator(Graph g) {
            this.graph = g;
            this.operation = null;
            this.position = 0;
            this.advance();
        }

        private final void advance() {
            this.operation = null;
            try (Reference reference = this.graph.ref();){
                Object[] nativeReturn = Graph.nextOperation(reference.nativeHandle(), this.position);
                if (nativeReturn != null && nativeReturn[0] != null && !((TF_Operation)((Object)nativeReturn[0])).isNull()) {
                    this.operation = new GraphOperation(this.graph, (TF_Operation)((Object)nativeReturn[0]));
                    this.position = (Integer)nativeReturn[1];
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.operation != null;
        }

        @Override
        public Operation next() {
            Operation rhett = this.operation;
            this.advance();
            return rhett;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is unsupported.");
        }
    }

    class Reference
    implements AutoCloseable {
        private boolean active;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Reference() {
            Object object = Graph.this.nativeHandleLock;
            synchronized (object) {
                boolean bl = this.active = Graph.this.nativeHandle != null && !Graph.this.nativeHandle.isNull();
                if (!this.active) {
                    throw new IllegalStateException("close() has been called on the Graph");
                }
                this.active = true;
                Graph.this.refcount++;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = Graph.this.nativeHandleLock;
            synchronized (object) {
                if (!this.active) {
                    return;
                }
                this.active = false;
                if (--Graph.this.refcount == 0) {
                    Graph.this.nativeHandleLock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TF_Graph nativeHandle() {
            Object object = Graph.this.nativeHandleLock;
            synchronized (object) {
                return this.active ? Graph.this.nativeHandle : null;
            }
        }
    }

    public static interface WhileSubgraphBuilder {
        public void buildSubgraph(Graph var1, Output<?>[] var2, Output<?>[] var3);
    }
}

