/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.buffer.layout;

import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.buffer.FloatDataBuffer;
import org.tensorflow.tools.buffer.impl.adapter.DataBufferAdapterFactory;
import org.tensorflow.tools.buffer.layout.DataLayout;

public interface FloatDataLayout<S extends DataBuffer<?>>
extends DataLayout<S, Float> {
    default public FloatDataBuffer applyTo(S buffer) {
        return DataBufferAdapterFactory.create(buffer, this);
    }

    public void writeFloat(S var1, float var2, long var3);

    public float readFloat(S var1, long var2);

    @Override
    default public void writeObject(S buffer, Float value, long index) {
        this.writeFloat(buffer, value.floatValue(), index);
    }

    @Override
    default public Float readObject(S buffer, long index) {
        return Float.valueOf(this.readFloat(buffer, index));
    }
}

