/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.buffer.impl.raw;

import java.nio.DoubleBuffer;
import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.buffer.DataStorageVisitor;
import org.tensorflow.tools.buffer.DoubleDataBuffer;
import org.tensorflow.tools.buffer.impl.Validator;
import org.tensorflow.tools.buffer.impl.raw.AbstractRawDataBuffer;
import org.tensorflow.tools.buffer.impl.raw.UnsafeMemoryHandle;

final class DoubleRawDataBuffer
extends AbstractRawDataBuffer<Double, DoubleDataBuffer>
implements DoubleDataBuffer {
    @Override
    public double getDouble(long index) {
        Validator.getArgs(this, index);
        return this.memory.getDouble(index);
    }

    @Override
    public DoubleDataBuffer setDouble(double value, long index) {
        Validator.setArgs(this, index);
        this.memory.setDouble(value, index);
        return this;
    }

    @Override
    public DoubleDataBuffer read(double[] dst) {
        return (DoubleDataBuffer)this.read(dst, dst.length);
    }

    @Override
    public DoubleDataBuffer read(double[] dst, int offset, int length) {
        return (DoubleDataBuffer)this.read(dst, dst.length, offset, length);
    }

    @Override
    public DoubleDataBuffer write(double[] src) {
        return (DoubleDataBuffer)this.write(src, src.length);
    }

    @Override
    public DoubleDataBuffer write(double[] src, int offset, int length) {
        return (DoubleDataBuffer)this.write(src, src.length, offset, length);
    }

    @Override
    public DoubleDataBuffer copyTo(final DataBuffer<Double> dst, final long size) {
        Validator.copyToArgs(this, dst, size);
        return dst.accept(new DataStorageVisitor<DoubleDataBuffer>(){

            @Override
            public DoubleDataBuffer visit(DoubleBuffer buffer) {
                if (buffer.hasArray()) {
                    DoubleRawDataBuffer.this.memory.copyTo(UnsafeMemoryHandle.fromArray(buffer.array(), buffer.position(), buffer.limit()), size);
                } else if (DoubleRawDataBuffer.this.memory.isArray()) {
                    buffer.put(DoubleRawDataBuffer.this.memory.toArrayDoubleBuffer());
                } else {
                    DoubleRawDataBuffer.this.slowCopyTo(dst, size);
                }
                return DoubleRawDataBuffer.this;
            }

            @Override
            public DoubleDataBuffer visit(long address, long length, long scale) {
                DoubleRawDataBuffer.this.memory.copyTo(UnsafeMemoryHandle.fromAddress(address, length, scale), size);
                return DoubleRawDataBuffer.this;
            }

            @Override
            public DoubleDataBuffer fallback() {
                if (dst instanceof DoubleDataBuffer) {
                    DoubleDataBuffer doubleDst = (DoubleDataBuffer)dst;
                    for (long idx = 0L; idx < size; ++idx) {
                        doubleDst.setDouble(DoubleRawDataBuffer.this.getDouble(idx), idx);
                    }
                    return DoubleRawDataBuffer.this;
                }
                return (DoubleDataBuffer)DoubleRawDataBuffer.this.slowCopyTo(dst, size);
            }
        });
    }

    @Override
    public <R> R accept(DataStorageVisitor<R> visitor) {
        if (this.memory.isArray()) {
            return visitor.visit(this.memory.toArrayDoubleBuffer());
        }
        return visitor.visit(this.memory.byteOffset, this.memory.byteSize, this.memory.scale);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleDataBuffer)) {
            return super.equals(obj);
        }
        final DoubleDataBuffer other = (DoubleDataBuffer)obj;
        if (this.size() != other.size()) {
            return false;
        }
        return other.accept(new DataStorageVisitor<Boolean>(){

            @Override
            public Boolean visit(DoubleBuffer buffer) {
                if (DoubleRawDataBuffer.this.memory.isArray()) {
                    return buffer.equals(DoubleRawDataBuffer.this.memory.toArrayDoubleBuffer());
                }
                return this.fallback();
            }

            @Override
            public Boolean fallback() {
                for (long idx = 0L; idx < DoubleRawDataBuffer.this.size(); ++idx) {
                    if (other.getDouble(idx) == DoubleRawDataBuffer.this.getDouble(idx)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    protected DoubleDataBuffer instantiate(UnsafeMemoryHandle memory) {
        return new DoubleRawDataBuffer(memory, this.readOnly);
    }

    DoubleRawDataBuffer(UnsafeMemoryHandle memory, boolean readOnly) {
        super(memory, readOnly);
    }
}

