/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.strings;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;

public final class StringNGrams<T extends TNumber>
extends RawOp {
    private Output<TString> ngrams;
    private Output<T> ngramsSplits;

    public static <T extends TNumber> StringNGrams<T> create(Scope scope, Operand<TString> data, Operand<T> dataSplits, String separator, List<Long> ngramWidths, String leftPad, String rightPad, Long padWidth, Boolean preserveShortSequences) {
        OperationBuilder opBuilder = scope.env().opBuilder("StringNGrams", scope.makeOpName("StringNGrams"));
        opBuilder.addInput(data.asOutput());
        opBuilder.addInput(dataSplits.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("separator", separator);
        long[] ngramWidthsArray = new long[ngramWidths.size()];
        for (int i = 0; i < ngramWidthsArray.length; ++i) {
            ngramWidthsArray[i] = ngramWidths.get(i);
        }
        opBuilder.setAttr("ngram_widths", ngramWidthsArray);
        opBuilder.setAttr("left_pad", leftPad);
        opBuilder.setAttr("right_pad", rightPad);
        opBuilder.setAttr("pad_width", padWidth);
        opBuilder.setAttr("preserve_short_sequences", preserveShortSequences);
        return new StringNGrams<T>(opBuilder.build());
    }

    public Output<TString> ngrams() {
        return this.ngrams;
    }

    public Output<T> ngramsSplits() {
        return this.ngramsSplits;
    }

    private StringNGrams(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.ngrams = operation.output(outputIdx++);
        this.ngramsSplits = operation.output(outputIdx++);
    }
}

