/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.strings;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TString;

public final class StringFormat
extends RawOp
implements Operand<TString> {
    private Output<TString> output;

    public static StringFormat create(Scope scope, Iterable<Operand<?>> inputs, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("StringFormat", scope.makeOpName("StringFormat"));
        opBuilder.addInputList(Operands.asOutputs(inputs));
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.template != null) {
                    opBuilder.setAttr("template", opts.template);
                }
                if (opts.placeholder != null) {
                    opBuilder.setAttr("placeholder", opts.placeholder);
                }
                if (opts.summarize == null) continue;
                opBuilder.setAttr("summarize", opts.summarize);
            }
        }
        return new StringFormat(opBuilder.build());
    }

    public static Options template(String template) {
        return new Options().template(template);
    }

    public static Options placeholder(String placeholder) {
        return new Options().placeholder(placeholder);
    }

    public static Options summarize(Long summarize) {
        return new Options().summarize(summarize);
    }

    public Output<TString> output() {
        return this.output;
    }

    @Override
    public Output<TString> asOutput() {
        return this.output;
    }

    private StringFormat(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private String template;
        private String placeholder;
        private Long summarize;

        public Options template(String template) {
            this.template = template;
            return this;
        }

        public Options placeholder(String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public Options summarize(Long summarize) {
            this.summarize = summarize;
            return this;
        }

        private Options() {
        }
    }
}

