/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

public final class SparseConcat<T extends TType>
extends RawOp {
    private Output<TInt64> outputIndices;
    private Output<T> outputValues;
    private Output<TInt64> outputShape;

    public static <T extends TType> SparseConcat<T> create(Scope scope, Iterable<Operand<TInt64>> indices, Iterable<Operand<T>> values, Iterable<Operand<TInt64>> shapes, Long concatDim) {
        OperationBuilder opBuilder = scope.env().opBuilder("SparseConcat", scope.makeOpName("SparseConcat"));
        opBuilder.addInputList(Operands.asOutputs(indices));
        opBuilder.addInputList(Operands.asOutputs(values));
        opBuilder.addInputList(Operands.asOutputs(shapes));
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("concat_dim", concatDim);
        return new SparseConcat<T>(opBuilder.build());
    }

    public Output<TInt64> outputIndices() {
        return this.outputIndices;
    }

    public Output<T> outputValues() {
        return this.outputValues;
    }

    public Output<TInt64> outputShape() {
        return this.outputShape;
    }

    private SparseConcat(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.outputIndices = operation.output(outputIdx++);
        this.outputValues = operation.output(outputIdx++);
        this.outputShape = operation.output(outputIdx++);
    }
}

