/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TType;

public final class QuantizedReluX<U extends TType>
extends RawOp {
    private Output<U> activations;
    private Output<TFloat32> minActivations;
    private Output<TFloat32> maxActivations;

    public static <U extends TType, T extends TType> QuantizedReluX<U> create(Scope scope, Operand<T> features, Operand<TFloat32> maxValue, Operand<TFloat32> minFeatures, Operand<TFloat32> maxFeatures, DataType<U> outType) {
        OperationBuilder opBuilder = scope.env().opBuilder("QuantizedReluX", scope.makeOpName("QuantizedReluX"));
        opBuilder.addInput(features.asOutput());
        opBuilder.addInput(maxValue.asOutput());
        opBuilder.addInput(minFeatures.asOutput());
        opBuilder.addInput(maxFeatures.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("out_type", outType);
        return new QuantizedReluX<U>(opBuilder.build());
    }

    public Output<U> activations() {
        return this.activations;
    }

    public Output<TFloat32> minActivations() {
        return this.minActivations;
    }

    public Output<TFloat32> maxActivations() {
        return this.maxActivations;
    }

    private QuantizedReluX(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.activations = operation.output(outputIdx++);
        this.minActivations = operation.output(outputIdx++);
        this.maxActivations = operation.output(outputIdx++);
    }
}

