/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class BatchNormWithGlobalNormalizationGrad<T extends TType>
extends RawOp {
    private Output<T> dx;
    private Output<T> dm;
    private Output<T> dv;
    private Output<T> db;
    private Output<T> dg;

    public static <T extends TType> BatchNormWithGlobalNormalizationGrad<T> create(Scope scope, Operand<T> t, Operand<T> m, Operand<T> v, Operand<T> gamma, Operand<T> backprop, Float varianceEpsilon, Boolean scaleAfterNormalization) {
        OperationBuilder opBuilder = scope.env().opBuilder("BatchNormWithGlobalNormalizationGrad", scope.makeOpName("BatchNormWithGlobalNormalizationGrad"));
        opBuilder.addInput(t.asOutput());
        opBuilder.addInput(m.asOutput());
        opBuilder.addInput(v.asOutput());
        opBuilder.addInput(gamma.asOutput());
        opBuilder.addInput(backprop.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("variance_epsilon", varianceEpsilon.floatValue());
        opBuilder.setAttr("scale_after_normalization", scaleAfterNormalization);
        return new BatchNormWithGlobalNormalizationGrad<T>(opBuilder.build());
    }

    public Output<T> dx() {
        return this.dx;
    }

    public Output<T> dm() {
        return this.dm;
    }

    public Output<T> dv() {
        return this.dv;
    }

    public Output<T> db() {
        return this.db;
    }

    public Output<T> dg() {
        return this.dg;
    }

    private BatchNormWithGlobalNormalizationGrad(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.dx = operation.output(outputIdx++);
        this.dm = operation.output(outputIdx++);
        this.dv = operation.output(outputIdx++);
        this.db = operation.output(outputIdx++);
        this.dg = operation.output(outputIdx++);
    }
}

