/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;

public final class ParseSingleSequenceExample
extends RawOp {
    private List<Output<TInt64>> contextSparseIndices;
    private List<Output<?>> contextSparseValues;
    private List<Output<TInt64>> contextSparseShapes;
    private List<Output<?>> contextDenseValues;
    private List<Output<TInt64>> featureListSparseIndices;
    private List<Output<?>> featureListSparseValues;
    private List<Output<TInt64>> featureListSparseShapes;
    private List<Output<?>> featureListDenseValues;

    public static ParseSingleSequenceExample create(Scope scope, Operand<TString> serialized, Operand<TString> featureListDenseMissingAssumedEmpty, Iterable<Operand<TString>> contextSparseKeys, Iterable<Operand<TString>> contextDenseKeys, Iterable<Operand<TString>> featureListSparseKeys, Iterable<Operand<TString>> featureListDenseKeys, Iterable<Operand<?>> contextDenseDefaults, Operand<TString> debugName, List<DataType<?>> contextSparseTypes, List<DataType<?>> featureListDenseTypes, List<DataType<?>> featureListSparseTypes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("ParseSingleSequenceExample", scope.makeOpName("ParseSingleSequenceExample"));
        opBuilder.addInput(serialized.asOutput());
        opBuilder.addInput(featureListDenseMissingAssumedEmpty.asOutput());
        opBuilder.addInputList(Operands.asOutputs(contextSparseKeys));
        opBuilder.addInputList(Operands.asOutputs(contextDenseKeys));
        opBuilder.addInputList(Operands.asOutputs(featureListSparseKeys));
        opBuilder.addInputList(Operands.asOutputs(featureListDenseKeys));
        opBuilder.addInputList(Operands.asOutputs(contextDenseDefaults));
        opBuilder.addInput(debugName.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] contextSparseTypesArray = new DataType[contextSparseTypes.size()];
        for (int i = 0; i < contextSparseTypesArray.length; ++i) {
            contextSparseTypesArray[i] = contextSparseTypes.get(i);
        }
        opBuilder.setAttr("context_sparse_types", contextSparseTypesArray);
        DataType[] featureListDenseTypesArray = new DataType[featureListDenseTypes.size()];
        for (int i = 0; i < featureListDenseTypesArray.length; ++i) {
            featureListDenseTypesArray[i] = featureListDenseTypes.get(i);
        }
        opBuilder.setAttr("feature_list_dense_types", featureListDenseTypesArray);
        DataType[] featureListSparseTypesArray = new DataType[featureListSparseTypes.size()];
        for (int i = 0; i < featureListSparseTypesArray.length; ++i) {
            featureListSparseTypesArray[i] = featureListSparseTypes.get(i);
        }
        opBuilder.setAttr("feature_list_sparse_types", featureListSparseTypesArray);
        if (options != null) {
            for (Options opts : options) {
                int i;
                if (opts.contextDenseShapes != null) {
                    Shape[] contextDenseShapesArray = new Shape[opts.contextDenseShapes.size()];
                    for (i = 0; i < contextDenseShapesArray.length; ++i) {
                        contextDenseShapesArray[i] = (Shape)opts.contextDenseShapes.get(i);
                    }
                    opBuilder.setAttr("context_dense_shapes", contextDenseShapesArray);
                }
                if (opts.featureListDenseShapes == null) continue;
                Shape[] featureListDenseShapesArray = new Shape[opts.featureListDenseShapes.size()];
                for (i = 0; i < featureListDenseShapesArray.length; ++i) {
                    featureListDenseShapesArray[i] = (Shape)opts.featureListDenseShapes.get(i);
                }
                opBuilder.setAttr("feature_list_dense_shapes", featureListDenseShapesArray);
            }
        }
        return new ParseSingleSequenceExample(opBuilder.build());
    }

    public static Options contextDenseShapes(List<Shape> contextDenseShapes) {
        return new Options().contextDenseShapes(contextDenseShapes);
    }

    public static Options featureListDenseShapes(List<Shape> featureListDenseShapes) {
        return new Options().featureListDenseShapes(featureListDenseShapes);
    }

    public List<Output<TInt64>> contextSparseIndices() {
        return this.contextSparseIndices;
    }

    public List<Output<?>> contextSparseValues() {
        return this.contextSparseValues;
    }

    public List<Output<TInt64>> contextSparseShapes() {
        return this.contextSparseShapes;
    }

    public List<Output<?>> contextDenseValues() {
        return this.contextDenseValues;
    }

    public List<Output<TInt64>> featureListSparseIndices() {
        return this.featureListSparseIndices;
    }

    public List<Output<?>> featureListSparseValues() {
        return this.featureListSparseValues;
    }

    public List<Output<TInt64>> featureListSparseShapes() {
        return this.featureListSparseShapes;
    }

    public List<Output<?>> featureListDenseValues() {
        return this.featureListDenseValues;
    }

    private ParseSingleSequenceExample(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int contextSparseIndicesLength = operation.outputListLength("context_sparse_indices");
        this.contextSparseIndices = Arrays.asList(operation.outputList(outputIdx, contextSparseIndicesLength));
        int contextSparseValuesLength = operation.outputListLength("context_sparse_values");
        this.contextSparseValues = Arrays.asList(operation.outputList(outputIdx += contextSparseIndicesLength, contextSparseValuesLength));
        int contextSparseShapesLength = operation.outputListLength("context_sparse_shapes");
        this.contextSparseShapes = Arrays.asList(operation.outputList(outputIdx += contextSparseValuesLength, contextSparseShapesLength));
        int contextDenseValuesLength = operation.outputListLength("context_dense_values");
        this.contextDenseValues = Arrays.asList(operation.outputList(outputIdx += contextSparseShapesLength, contextDenseValuesLength));
        int featureListSparseIndicesLength = operation.outputListLength("feature_list_sparse_indices");
        this.featureListSparseIndices = Arrays.asList(operation.outputList(outputIdx += contextDenseValuesLength, featureListSparseIndicesLength));
        int featureListSparseValuesLength = operation.outputListLength("feature_list_sparse_values");
        this.featureListSparseValues = Arrays.asList(operation.outputList(outputIdx += featureListSparseIndicesLength, featureListSparseValuesLength));
        int featureListSparseShapesLength = operation.outputListLength("feature_list_sparse_shapes");
        this.featureListSparseShapes = Arrays.asList(operation.outputList(outputIdx += featureListSparseValuesLength, featureListSparseShapesLength));
        int featureListDenseValuesLength = operation.outputListLength("feature_list_dense_values");
        this.featureListDenseValues = Arrays.asList(operation.outputList(outputIdx += featureListSparseShapesLength, featureListDenseValuesLength));
        outputIdx += featureListDenseValuesLength;
    }

    public static class Options {
        private List<Shape> contextDenseShapes;
        private List<Shape> featureListDenseShapes;

        public Options contextDenseShapes(List<Shape> contextDenseShapes) {
            this.contextDenseShapes = contextDenseShapes;
            return this;
        }

        public Options featureListDenseShapes(List<Shape> featureListDenseShapes) {
            this.featureListDenseShapes = featureListDenseShapes;
            return this;
        }

        private Options() {
        }
    }
}

