/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class MutableHashTableOfTensors
extends RawOp
implements Operand<TType> {
    private Output<?> tableHandle;

    public static <T extends TType, U extends TType> MutableHashTableOfTensors create(Scope scope, DataType<T> keyDtype, DataType<U> valueDtype, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("MutableHashTableOfTensorsV2", scope.makeOpName("MutableHashTableOfTensors"));
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("key_dtype", keyDtype);
        opBuilder.setAttr("value_dtype", valueDtype);
        if (options != null) {
            for (Options opts : options) {
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName != null) {
                    opBuilder.setAttr("shared_name", opts.sharedName);
                }
                if (opts.useNodeNameSharing != null) {
                    opBuilder.setAttr("use_node_name_sharing", opts.useNodeNameSharing);
                }
                if (opts.valueShape == null) continue;
                opBuilder.setAttr("value_shape", opts.valueShape);
            }
        }
        return new MutableHashTableOfTensors(opBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public static Options useNodeNameSharing(Boolean useNodeNameSharing) {
        return new Options().useNodeNameSharing(useNodeNameSharing);
    }

    public static Options valueShape(Shape valueShape) {
        return new Options().valueShape(valueShape);
    }

    public Output<?> tableHandle() {
        return this.tableHandle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.tableHandle;
    }

    private MutableHashTableOfTensors(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.tableHandle = operation.output(outputIdx++);
    }

    public static class Options {
        private String container;
        private String sharedName;
        private Boolean useNodeNameSharing;
        private Shape valueShape;

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        public Options useNodeNameSharing(Boolean useNodeNameSharing) {
            this.useNodeNameSharing = useNodeNameSharing;
            return this;
        }

        public Options valueShape(Shape valueShape) {
            this.valueShape = valueShape;
            return this;
        }

        private Options() {
        }
    }
}

