/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.ndarray.impl.dimension;

import org.tensorflow.tools.ndarray.impl.dimension.AbstractDimension;

final class Axis
extends AbstractDimension {
    private final long numElements;
    private final long elementSize;

    @Override
    public long numElements() {
        return this.numElements;
    }

    @Override
    public long positionOf(long coord) {
        if (coord >= this.numElements) {
            throw new IndexOutOfBoundsException();
        }
        return this.elementSize * coord;
    }

    @Override
    public boolean isSegmented() {
        return false;
    }

    @Override
    public long elementSize() {
        return this.elementSize;
    }

    @Override
    public long physicalSize() {
        return this.elementSize * this.numElements;
    }

    public String toString() {
        return String.valueOf(this.numElements);
    }

    Axis(long numElements, long elementSize) {
        this.numElements = numElements;
        this.elementSize = elementSize;
    }
}

