/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.ndarray.impl.dense;

import org.tensorflow.tools.buffer.BooleanDataBuffer;
import org.tensorflow.tools.buffer.ByteDataBuffer;
import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.buffer.DoubleDataBuffer;
import org.tensorflow.tools.buffer.FloatDataBuffer;
import org.tensorflow.tools.buffer.IntDataBuffer;
import org.tensorflow.tools.buffer.LongDataBuffer;
import org.tensorflow.tools.buffer.ShortDataBuffer;
import org.tensorflow.tools.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.tools.ndarray.impl.sequence.PositionIterator;

final class DataTransfer {
    DataTransfer() {
    }

    static <T, B extends DataBuffer<T>> void ofValue(B srcBuf, long srcIdx, B dstBuf, long dstIdx) {
        dstBuf.setObject(srcBuf.getObject(srcIdx), dstIdx);
    }

    static void ofByte(ByteDataBuffer srcBuf, long srcIdx, ByteDataBuffer dstBuf, long dstIdx) {
        dstBuf.setByte(srcBuf.getByte(srcIdx), dstIdx);
    }

    static void ofInt(IntDataBuffer srcBuf, long srcIdx, IntDataBuffer dstBuf, long dstIdx) {
        dstBuf.setInt(srcBuf.getInt(srcIdx), dstIdx);
    }

    static void ofLong(LongDataBuffer srcBuf, long srcIdx, LongDataBuffer dstBuf, long dstIdx) {
        dstBuf.setLong(srcBuf.getLong(srcIdx), dstIdx);
    }

    static void ofDouble(DoubleDataBuffer srcBuf, long srcIdx, DoubleDataBuffer dstBuf, long dstIdx) {
        dstBuf.setDouble(srcBuf.getDouble(srcIdx), dstIdx);
    }

    static void ofFloat(FloatDataBuffer srcBuf, long srcIdx, FloatDataBuffer dstBuf, long dstIdx) {
        dstBuf.setFloat(srcBuf.getFloat(srcIdx), dstIdx);
    }

    static void ofShort(ShortDataBuffer srcBuf, long srcIdx, ShortDataBuffer dstBuf, long dstIdx) {
        dstBuf.setShort(srcBuf.getShort(srcIdx), dstIdx);
    }

    static void ofBoolean(BooleanDataBuffer srcBuf, long srcIdx, BooleanDataBuffer dstBuf, long dstIdx) {
        dstBuf.setBoolean(srcBuf.getBoolean(srcIdx), dstIdx);
    }

    static <T, B extends DataBuffer<T>> void execute(B srcBuffer, DimensionalSpace srcDimensions, B dstBuffer, DimensionalSpace dstDimensions, OfValue<B> valueTransfer) {
        if (srcDimensions.isSegmented() || dstDimensions.isSegmented()) {
            int segmentationIdx = Math.max(srcDimensions.segmentationIdx(), dstDimensions.segmentationIdx());
            DataTransfer.copyByElement(srcBuffer, PositionIterator.create(srcDimensions, segmentationIdx), dstBuffer, PositionIterator.create(dstDimensions, segmentationIdx), srcDimensions.get(segmentationIdx).elementSize(), valueTransfer);
        } else {
            srcBuffer.copyTo(dstBuffer, srcDimensions.physicalSize());
        }
    }

    static <T, B extends DataBuffer<T>> void execute(B srcBuffer, B dstBuffer, DimensionalSpace dstDimensions, OfValue<B> valueTransfer) {
        if (dstDimensions.isSegmented()) {
            long elementSize = dstDimensions.get(dstDimensions.segmentationIdx()).elementSize();
            DataTransfer.copyByElement(srcBuffer, PositionIterator.sequence(elementSize, srcBuffer.size()), dstBuffer, PositionIterator.create(dstDimensions, dstDimensions.segmentationIdx()), elementSize, valueTransfer);
        } else {
            srcBuffer.copyTo(dstBuffer, dstDimensions.physicalSize());
        }
    }

    static <T, B extends DataBuffer<T>> void execute(B srcBuffer, DimensionalSpace srcDimensions, B dstBuffer, OfValue<B> valueTransfer) {
        if (srcDimensions.isSegmented()) {
            long elementSize = srcDimensions.get(srcDimensions.segmentationIdx()).elementSize();
            DataTransfer.copyByElement(srcBuffer, PositionIterator.create(srcDimensions, srcDimensions.segmentationIdx()), dstBuffer, PositionIterator.sequence(elementSize, dstBuffer.size()), elementSize, valueTransfer);
        } else {
            srcBuffer.copyTo(dstBuffer, srcDimensions.physicalSize());
        }
    }

    private static <T, B extends DataBuffer<T>> void copyByElement(B srcBuffer, PositionIterator srcIterator, B dstBuffer, PositionIterator dstIterator, long elementSize, OfValue<B> valueTransfer) {
        if (elementSize == 1L) {
            while (srcIterator.hasNext()) {
                valueTransfer.copy(srcBuffer, srcIterator.nextLong(), dstBuffer, dstIterator.nextLong());
            }
        } else {
            while (srcIterator.hasNext()) {
                srcBuffer.offset(srcIterator.nextLong()).copyTo(dstBuffer.offset(dstIterator.nextLong()), elementSize);
            }
        }
    }

    @FunctionalInterface
    static interface OfValue<B extends DataBuffer<?>> {
        public void copy(B var1, long var2, B var4, long var5);
    }
}

