/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.buffer.impl.adapter;

import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.buffer.FloatDataBuffer;
import org.tensorflow.tools.buffer.impl.Validator;
import org.tensorflow.tools.buffer.impl.adapter.AbstractDataBufferAdapter;
import org.tensorflow.tools.buffer.layout.FloatDataLayout;

class FloatDataBufferAdapter<S extends DataBuffer<?>>
extends AbstractDataBufferAdapter<S, Float, FloatDataBuffer>
implements FloatDataBuffer {
    private FloatDataLayout<S> layout;

    @Override
    public float getFloat(long index) {
        Validator.getArgs(this, index);
        return this.layout.readFloat(this.buffer(), index * (long)this.layout.scale());
    }

    @Override
    public FloatDataBuffer setFloat(float value, long index) {
        Validator.setArgs(this, index);
        this.layout.writeFloat(this.buffer(), value, index * (long)this.layout.scale());
        return this;
    }

    @Override
    public FloatDataBuffer read(float[] dst, int offset, int length) {
        Validator.readArgs(this, dst.length, offset, length);
        int i = 0;
        int j = offset;
        while (i < length) {
            dst[j] = this.layout.readFloat(this.buffer(), i * this.layout.scale());
            ++i;
            ++j;
        }
        return this;
    }

    @Override
    public FloatDataBuffer write(float[] src, int offset, int length) {
        Validator.writeArgs(this, src.length, offset, length);
        int i = 0;
        int j = offset;
        while (i < length) {
            this.layout.writeFloat(this.buffer(), src[j], i * this.layout.scale());
            ++i;
            ++j;
        }
        return this;
    }

    @Override
    public FloatDataBuffer copyTo(DataBuffer<Float> dst, long size) {
        Validator.copyToArgs(this, dst, size);
        if (dst instanceof FloatDataBuffer) {
            FloatDataBuffer floatDst = (FloatDataBuffer)dst;
            for (long idx = 0L; idx < size; ++idx) {
                floatDst.setFloat(this.getFloat(idx), idx);
            }
            return this;
        }
        return (FloatDataBuffer)this.slowCopyTo(dst, size);
    }

    @Override
    public FloatDataBuffer offset(long index) {
        return new FloatDataBufferAdapter(this.buffer().offset(index * (long)this.layout.scale()), this.layout);
    }

    @Override
    public FloatDataBuffer narrow(long size) {
        return new FloatDataBufferAdapter(this.buffer().narrow(size * (long)this.layout.scale()), this.layout);
    }

    @Override
    public FloatDataBuffer slice(long index, long size) {
        return new FloatDataBufferAdapter(this.buffer().slice(index * (long)this.layout.scale(), size * (long)this.layout.scale()), this.layout);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FloatDataBuffer)) {
            return super.equals(obj);
        }
        FloatDataBuffer other = (FloatDataBuffer)obj;
        if (other.size() != this.size()) {
            return false;
        }
        for (long idx = 0L; idx < this.size(); ++idx) {
            if (other.getFloat(idx) == this.getFloat(idx)) continue;
            return false;
        }
        return true;
    }

    FloatDataBufferAdapter(S buffer, FloatDataLayout<S> layout) {
        super(buffer, layout);
        this.layout = layout;
    }
}

