/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.List;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;

public final class TPUReplicateMetadata
extends RawOp {
    public static TPUReplicateMetadata create(Scope scope, Long numReplicas, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("TPUReplicateMetadata", scope.makeOpName("TPUReplicateMetadata"));
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("num_replicas", numReplicas);
        if (options != null) {
            for (Options opts : options) {
                int i;
                if (opts.numCoresPerReplica != null) {
                    opBuilder.setAttr("num_cores_per_replica", opts.numCoresPerReplica);
                }
                if (opts.topology != null) {
                    opBuilder.setAttr("topology", opts.topology);
                }
                if (opts.useTpu != null) {
                    opBuilder.setAttr("use_tpu", opts.useTpu);
                }
                if (opts.deviceAssignment != null) {
                    long[] deviceAssignmentArray = new long[opts.deviceAssignment.size()];
                    for (i = 0; i < deviceAssignmentArray.length; ++i) {
                        deviceAssignmentArray[i] = (Long)opts.deviceAssignment.get(i);
                    }
                    opBuilder.setAttr("device_assignment", deviceAssignmentArray);
                }
                if (opts.computationShape != null) {
                    long[] computationShapeArray = new long[opts.computationShape.size()];
                    for (i = 0; i < computationShapeArray.length; ++i) {
                        computationShapeArray[i] = (Long)opts.computationShape.get(i);
                    }
                    opBuilder.setAttr("computation_shape", computationShapeArray);
                }
                if (opts.hostComputeCore != null) {
                    String[] hostComputeCoreArray = new String[opts.hostComputeCore.size()];
                    for (i = 0; i < hostComputeCoreArray.length; ++i) {
                        hostComputeCoreArray[i] = (String)opts.hostComputeCore.get(i);
                    }
                    opBuilder.setAttr("host_compute_core", hostComputeCoreArray);
                }
                if (opts.paddingMap != null) {
                    String[] paddingMapArray = new String[opts.paddingMap.size()];
                    for (i = 0; i < paddingMapArray.length; ++i) {
                        paddingMapArray[i] = (String)opts.paddingMap.get(i);
                    }
                    opBuilder.setAttr("padding_map", paddingMapArray);
                }
                if (opts.stepMarkerLocation != null) {
                    opBuilder.setAttr("step_marker_location", opts.stepMarkerLocation);
                }
                if (opts.allowSoftPlacement == null) continue;
                opBuilder.setAttr("allow_soft_placement", opts.allowSoftPlacement);
            }
        }
        return new TPUReplicateMetadata(opBuilder.build());
    }

    public static Options numCoresPerReplica(Long numCoresPerReplica) {
        return new Options().numCoresPerReplica(numCoresPerReplica);
    }

    public static Options topology(String topology) {
        return new Options().topology(topology);
    }

    public static Options useTpu(Boolean useTpu) {
        return new Options().useTpu(useTpu);
    }

    public static Options deviceAssignment(List<Long> deviceAssignment) {
        return new Options().deviceAssignment(deviceAssignment);
    }

    public static Options computationShape(List<Long> computationShape) {
        return new Options().computationShape(computationShape);
    }

    public static Options hostComputeCore(List<String> hostComputeCore) {
        return new Options().hostComputeCore(hostComputeCore);
    }

    public static Options paddingMap(List<String> paddingMap) {
        return new Options().paddingMap(paddingMap);
    }

    public static Options stepMarkerLocation(String stepMarkerLocation) {
        return new Options().stepMarkerLocation(stepMarkerLocation);
    }

    public static Options allowSoftPlacement(Boolean allowSoftPlacement) {
        return new Options().allowSoftPlacement(allowSoftPlacement);
    }

    private TPUReplicateMetadata(Operation operation) {
        super(operation);
    }

    public static class Options {
        private Long numCoresPerReplica;
        private String topology;
        private Boolean useTpu;
        private List<Long> deviceAssignment;
        private List<Long> computationShape;
        private List<String> hostComputeCore;
        private List<String> paddingMap;
        private String stepMarkerLocation;
        private Boolean allowSoftPlacement;

        public Options numCoresPerReplica(Long numCoresPerReplica) {
            this.numCoresPerReplica = numCoresPerReplica;
            return this;
        }

        public Options topology(String topology) {
            this.topology = topology;
            return this;
        }

        public Options useTpu(Boolean useTpu) {
            this.useTpu = useTpu;
            return this;
        }

        public Options deviceAssignment(List<Long> deviceAssignment) {
            this.deviceAssignment = deviceAssignment;
            return this;
        }

        public Options computationShape(List<Long> computationShape) {
            this.computationShape = computationShape;
            return this;
        }

        public Options hostComputeCore(List<String> hostComputeCore) {
            this.hostComputeCore = hostComputeCore;
            return this;
        }

        public Options paddingMap(List<String> paddingMap) {
            this.paddingMap = paddingMap;
            return this;
        }

        public Options stepMarkerLocation(String stepMarkerLocation) {
            this.stepMarkerLocation = stepMarkerLocation;
            return this;
        }

        public Options allowSoftPlacement(Boolean allowSoftPlacement) {
            this.allowSoftPlacement = allowSoftPlacement;
            return this;
        }

        private Options() {
        }
    }
}

