/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TString;

public final class ConfigureDistributedTPU
extends RawOp
implements Operand<TString> {
    private Output<TString> topology;

    public static ConfigureDistributedTPU create(Scope scope, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("ConfigureDistributedTPU", scope.makeOpName("ConfigureDistributedTPU"));
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.embeddingConfig != null) {
                    opBuilder.setAttr("embedding_config", opts.embeddingConfig);
                }
                if (opts.tpuEmbeddingConfig != null) {
                    opBuilder.setAttr("tpu_embedding_config", opts.tpuEmbeddingConfig);
                }
                if (opts.isGlobalInit != null) {
                    opBuilder.setAttr("is_global_init", opts.isGlobalInit);
                }
                if (opts.enableWholeMeshCompilations != null) {
                    opBuilder.setAttr("enable_whole_mesh_compilations", opts.enableWholeMeshCompilations);
                }
                if (opts.compilationFailureClosesChips == null) continue;
                opBuilder.setAttr("compilation_failure_closes_chips", opts.compilationFailureClosesChips);
            }
        }
        return new ConfigureDistributedTPU(opBuilder.build());
    }

    public static Options embeddingConfig(String embeddingConfig) {
        return new Options().embeddingConfig(embeddingConfig);
    }

    public static Options tpuEmbeddingConfig(String tpuEmbeddingConfig) {
        return new Options().tpuEmbeddingConfig(tpuEmbeddingConfig);
    }

    public static Options isGlobalInit(Boolean isGlobalInit) {
        return new Options().isGlobalInit(isGlobalInit);
    }

    public static Options enableWholeMeshCompilations(Boolean enableWholeMeshCompilations) {
        return new Options().enableWholeMeshCompilations(enableWholeMeshCompilations);
    }

    public static Options compilationFailureClosesChips(Boolean compilationFailureClosesChips) {
        return new Options().compilationFailureClosesChips(compilationFailureClosesChips);
    }

    public Output<TString> topology() {
        return this.topology;
    }

    @Override
    public Output<TString> asOutput() {
        return this.topology;
    }

    private ConfigureDistributedTPU(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.topology = operation.output(outputIdx++);
    }

    public static class Options {
        private String embeddingConfig;
        private String tpuEmbeddingConfig;
        private Boolean isGlobalInit;
        private Boolean enableWholeMeshCompilations;
        private Boolean compilationFailureClosesChips;

        public Options embeddingConfig(String embeddingConfig) {
            this.embeddingConfig = embeddingConfig;
            return this;
        }

        public Options tpuEmbeddingConfig(String tpuEmbeddingConfig) {
            this.tpuEmbeddingConfig = tpuEmbeddingConfig;
            return this;
        }

        public Options isGlobalInit(Boolean isGlobalInit) {
            this.isGlobalInit = isGlobalInit;
            return this;
        }

        public Options enableWholeMeshCompilations(Boolean enableWholeMeshCompilations) {
            this.enableWholeMeshCompilations = enableWholeMeshCompilations;
            return this;
        }

        public Options compilationFailureClosesChips(Boolean compilationFailureClosesChips) {
            this.compilationFailureClosesChips = compilationFailureClosesChips;
            return this;
        }

        private Options() {
        }
    }
}

