/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TInt64;

public final class SparseCrossHashed
extends RawOp {
    private Output<TInt64> outputIndices;
    private Output<TInt64> outputValues;
    private Output<TInt64> outputShape;

    public static SparseCrossHashed create(Scope scope, Iterable<Operand<TInt64>> indices, Iterable<Operand<?>> values, Iterable<Operand<TInt64>> shapes, Iterable<Operand<?>> denseInputs, Operand<TInt64> numBuckets, Operand<TBool> strongHash, Operand<TInt64> salt) {
        OperationBuilder opBuilder = scope.env().opBuilder("SparseCrossHashed", scope.makeOpName("SparseCrossHashed"));
        opBuilder.addInputList(Operands.asOutputs(indices));
        opBuilder.addInputList(Operands.asOutputs(values));
        opBuilder.addInputList(Operands.asOutputs(shapes));
        opBuilder.addInputList(Operands.asOutputs(denseInputs));
        opBuilder.addInput(numBuckets.asOutput());
        opBuilder.addInput(strongHash.asOutput());
        opBuilder.addInput(salt.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        return new SparseCrossHashed(opBuilder.build());
    }

    public Output<TInt64> outputIndices() {
        return this.outputIndices;
    }

    public Output<TInt64> outputValues() {
        return this.outputValues;
    }

    public Output<TInt64> outputShape() {
        return this.outputShape;
    }

    private SparseCrossHashed(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.outputIndices = operation.output(outputIdx++);
        this.outputValues = operation.output(outputIdx++);
        this.outputShape = operation.output(outputIdx++);
    }
}

