/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.estimator;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

public final class BoostedTreesBucketize
extends RawOp
implements Iterable<Operand<TInt32>> {
    private List<Output<TInt32>> buckets;

    public static BoostedTreesBucketize create(Scope scope, Iterable<Operand<TFloat32>> floatValues, Iterable<Operand<TFloat32>> bucketBoundaries) {
        OperationBuilder opBuilder = scope.env().opBuilder("BoostedTreesBucketize", scope.makeOpName("BoostedTreesBucketize"));
        opBuilder.addInputList(Operands.asOutputs(floatValues));
        opBuilder.addInputList(Operands.asOutputs(bucketBoundaries));
        opBuilder = scope.applyControlDependencies(opBuilder);
        return new BoostedTreesBucketize(opBuilder.build());
    }

    public List<Output<TInt32>> buckets() {
        return this.buckets;
    }

    @Override
    public Iterator<Operand<TInt32>> iterator() {
        return this.buckets.iterator();
    }

    private BoostedTreesBucketize(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int bucketsLength = operation.outputListLength("buckets");
        this.buckets = Arrays.asList(operation.outputList(outputIdx, bucketsLength));
        outputIdx += bucketsLength;
    }
}

