/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.Objects;
import org.bytedeco.javacpp.Pointer;
import org.tensorflow.AbstractOperation;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.Tensor;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.types.family.TType;

public final class Output<T extends TType>
implements Operand<T> {
    private final AbstractOperation operation;
    private final int index;

    public int index() {
        return this.index;
    }

    public Shape shape() {
        return this.operation.shape(this.index);
    }

    public DataType<T> dataType() {
        return this.operation.dtype(this.index);
    }

    public <U extends TType> Output<U> expect(DataType<U> dt) {
        if (!dt.equals(this.dataType())) {
            throw new IllegalArgumentException("Cannot cast from output of " + this.dataType() + " to output of " + dt);
        }
        return this;
    }

    public Tensor<T> tensor() {
        return this.operation.tensor(this.index);
    }

    @Override
    public Operation op() {
        return this.operation;
    }

    @Override
    public Output<T> asOutput() {
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.operation, this.index);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Output) {
            Output that = (Output)o;
            return this.index == that.index && this.operation.equals(that.operation);
        }
        return false;
    }

    public String toString() {
        return String.format("<%s '%s:%d' shape=%s dtype=%s>", this.operation.type(), this.operation.name(), this.index, this.shape().toString(), this.dataType());
    }

    Output(AbstractOperation op, int idx) {
        this.operation = op;
        this.index = idx;
    }

    Pointer getUnsafeNativeHandle() {
        return this.operation.getUnsafeNativeHandle(this.index);
    }
}

