/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.buffer.impl.layout;

import org.tensorflow.tools.buffer.ShortDataBuffer;
import org.tensorflow.tools.buffer.layout.FloatDataLayout;

public final class Bfloat16Layout
implements FloatDataLayout<ShortDataBuffer> {
    @Override
    public void writeFloat(ShortDataBuffer buffer, float value, long index) {
        buffer.setShort(Bfloat16Layout.float32to16(value), index);
    }

    @Override
    public float readFloat(ShortDataBuffer buffer, long index) {
        return Bfloat16Layout.float16to32(buffer.getShort(index));
    }

    static short float32to16(float f32) {
        return (short)(Float.floatToIntBits(f32) >>> 16);
    }

    static float float16to32(short i16) {
        return Float.intBitsToFloat(i16 << 16);
    }
}

