/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TString;

public final class Rpc
extends RawOp
implements Operand<TString> {
    private Output<TString> response;

    public static Rpc create(Scope scope, Operand<TString> address, Operand<TString> method, Operand<TString> request, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("Rpc", scope.makeOpName("Rpc"));
        opBuilder.addInput(address.asOutput());
        opBuilder.addInput(method.asOutput());
        opBuilder.addInput(request.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.protocol != null) {
                    opBuilder.setAttr("protocol", opts.protocol);
                }
                if (opts.failFast != null) {
                    opBuilder.setAttr("fail_fast", opts.failFast);
                }
                if (opts.timeoutInMs == null) continue;
                opBuilder.setAttr("timeout_in_ms", opts.timeoutInMs);
            }
        }
        return new Rpc(opBuilder.build());
    }

    public static Options protocol(String protocol) {
        return new Options().protocol(protocol);
    }

    public static Options failFast(Boolean failFast) {
        return new Options().failFast(failFast);
    }

    public static Options timeoutInMs(Long timeoutInMs) {
        return new Options().timeoutInMs(timeoutInMs);
    }

    public Output<TString> response() {
        return this.response;
    }

    @Override
    public Output<TString> asOutput() {
        return this.response;
    }

    private Rpc(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.response = operation.output(outputIdx++);
    }

    public static class Options {
        private String protocol;
        private Boolean failFast;
        private Long timeoutInMs;

        public Options protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Options failFast(Boolean failFast) {
            this.failFast = failFast;
            return this;
        }

        public Options timeoutInMs(Long timeoutInMs) {
            this.timeoutInMs = timeoutInMs;
            return this;
        }

        private Options() {
        }
    }
}

