/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.op.Scope;
import org.tensorflow.op.quantization.Dequantize;
import org.tensorflow.op.quantization.FakeQuantWithMinMaxArgs;
import org.tensorflow.op.quantization.FakeQuantWithMinMaxArgsGradient;
import org.tensorflow.op.quantization.FakeQuantWithMinMaxVars;
import org.tensorflow.op.quantization.FakeQuantWithMinMaxVarsGradient;
import org.tensorflow.op.quantization.FakeQuantWithMinMaxVarsPerChannel;
import org.tensorflow.op.quantization.FakeQuantWithMinMaxVarsPerChannelGradient;
import org.tensorflow.op.quantization.Quantize;
import org.tensorflow.op.quantization.QuantizeAndDequantize;
import org.tensorflow.op.quantization.QuantizeDownAndShrinkRange;
import org.tensorflow.op.quantization.QuantizedConcat;
import org.tensorflow.op.quantization.RequantizationRange;
import org.tensorflow.op.quantization.Requantize;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class QuantizationOps {
    private final Scope scope;

    QuantizationOps(Scope scope) {
        this.scope = scope;
    }

    public <T extends TType> Dequantize<TFloat32> dequantize(Operand<T> input, Operand<TFloat32> minRange, Operand<TFloat32> maxRange, Dequantize.Options ... options) {
        return Dequantize.create(this.scope, input, minRange, maxRange, options);
    }

    public <U extends TNumber, T extends TType> Dequantize<U> dequantize(Operand<T> input, Operand<TFloat32> minRange, Operand<TFloat32> maxRange, DataType<U> dtype, Dequantize.Options ... options) {
        return Dequantize.create(this.scope, input, minRange, maxRange, dtype, options);
    }

    public FakeQuantWithMinMaxArgs fakeQuantWithMinMaxArgs(Operand<TFloat32> inputs, FakeQuantWithMinMaxArgs.Options ... options) {
        return FakeQuantWithMinMaxArgs.create(this.scope, inputs, options);
    }

    public FakeQuantWithMinMaxArgsGradient fakeQuantWithMinMaxArgsGradient(Operand<TFloat32> gradients, Operand<TFloat32> inputs, FakeQuantWithMinMaxArgsGradient.Options ... options) {
        return FakeQuantWithMinMaxArgsGradient.create(this.scope, gradients, inputs, options);
    }

    public FakeQuantWithMinMaxVars fakeQuantWithMinMaxVars(Operand<TFloat32> inputs, Operand<TFloat32> min, Operand<TFloat32> max, FakeQuantWithMinMaxVars.Options ... options) {
        return FakeQuantWithMinMaxVars.create(this.scope, inputs, min, max, options);
    }

    public FakeQuantWithMinMaxVarsGradient fakeQuantWithMinMaxVarsGradient(Operand<TFloat32> gradients, Operand<TFloat32> inputs, Operand<TFloat32> min, Operand<TFloat32> max, FakeQuantWithMinMaxVarsGradient.Options ... options) {
        return FakeQuantWithMinMaxVarsGradient.create(this.scope, gradients, inputs, min, max, options);
    }

    public FakeQuantWithMinMaxVarsPerChannel fakeQuantWithMinMaxVarsPerChannel(Operand<TFloat32> inputs, Operand<TFloat32> min, Operand<TFloat32> max, FakeQuantWithMinMaxVarsPerChannel.Options ... options) {
        return FakeQuantWithMinMaxVarsPerChannel.create(this.scope, inputs, min, max, options);
    }

    public FakeQuantWithMinMaxVarsPerChannelGradient fakeQuantWithMinMaxVarsPerChannelGradient(Operand<TFloat32> gradients, Operand<TFloat32> inputs, Operand<TFloat32> min, Operand<TFloat32> max, FakeQuantWithMinMaxVarsPerChannelGradient.Options ... options) {
        return FakeQuantWithMinMaxVarsPerChannelGradient.create(this.scope, gradients, inputs, min, max, options);
    }

    public <T extends TType> Quantize<T> quantize(Operand<TFloat32> input, Operand<TFloat32> minRange, Operand<TFloat32> maxRange, DataType<T> T, Quantize.Options ... options) {
        return Quantize.create(this.scope, input, minRange, maxRange, T, options);
    }

    public <T extends TNumber> QuantizeAndDequantize<T> quantizeAndDequantize(Operand<T> input, Operand<T> inputMin, Operand<T> inputMax, Operand<TInt32> numBits, QuantizeAndDequantize.Options ... options) {
        return QuantizeAndDequantize.create(this.scope, input, inputMin, inputMax, numBits, options);
    }

    public <U extends TType, T extends TType> QuantizeDownAndShrinkRange<U> quantizeDownAndShrinkRange(Operand<T> input, Operand<TFloat32> inputMin, Operand<TFloat32> inputMax, DataType<U> outType) {
        return QuantizeDownAndShrinkRange.create(this.scope, input, inputMin, inputMax, outType);
    }

    public <T extends TType> QuantizedConcat<T> quantizedConcat(Operand<TInt32> concatDim, Iterable<Operand<T>> values, Iterable<Operand<TFloat32>> inputMins, Iterable<Operand<TFloat32>> inputMaxes) {
        return QuantizedConcat.create(this.scope, concatDim, values, inputMins, inputMaxes);
    }

    public <T extends TType> RequantizationRange requantizationRange(Operand<T> input, Operand<TFloat32> inputMin, Operand<TFloat32> inputMax) {
        return RequantizationRange.create(this.scope, input, inputMin, inputMax);
    }

    public <U extends TType, T extends TType> Requantize<U> requantize(Operand<T> input, Operand<TFloat32> inputMin, Operand<TFloat32> inputMax, Operand<TFloat32> requestedOutputMin, Operand<TFloat32> requestedOutputMax, DataType<U> outType) {
        return Requantize.create(this.scope, input, inputMin, inputMax, requestedOutputMin, requestedOutputMax, outType);
    }
}

