/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.types;

import java.util.function.Consumer;
import org.tensorflow.DataType;
import org.tensorflow.Tensor;
import org.tensorflow.tools.Shape;
import org.tensorflow.tools.buffer.ByteDataBuffer;
import org.tensorflow.tools.ndarray.ByteNdArray;
import org.tensorflow.tools.ndarray.NdArray;
import org.tensorflow.tools.ndarray.StdArrays;
import org.tensorflow.types.TUint8Impl;
import org.tensorflow.types.family.TNumber;

public interface TUint8
extends ByteNdArray,
TNumber {
    public static final DataType<TUint8> DTYPE = DataType.create("UINT8", 4, 1, TUint8Impl::mapTensor);

    public static Tensor<TUint8> scalarOf(byte value) {
        return Tensor.of(DTYPE, Shape.scalar(), data -> data.setByte(value, new long[0]));
    }

    public static Tensor<TUint8> vectorOf(byte ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        return Tensor.of(DTYPE, Shape.of(values.length), data -> StdArrays.copyTo((ByteNdArray)data, values));
    }

    public static Tensor<TUint8> tensorOf(NdArray<Byte> src) {
        return Tensor.of(DTYPE, src.shape(), src::copyTo);
    }

    public static Tensor<TUint8> tensorOf(Shape shape) {
        return Tensor.of(DTYPE, shape);
    }

    public static Tensor<TUint8> tensorOf(Shape shape, ByteDataBuffer data) {
        return Tensor.of(DTYPE, shape, d -> d.write(data));
    }

    public static Tensor<TUint8> tensorOf(Shape shape, Consumer<TUint8> dataInit) {
        return Tensor.of(DTYPE, shape, dataInit);
    }
}

