/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.types;

import java.util.function.Consumer;
import org.tensorflow.DataType;
import org.tensorflow.Tensor;
import org.tensorflow.tools.Shape;
import org.tensorflow.tools.buffer.DoubleDataBuffer;
import org.tensorflow.tools.ndarray.DoubleNdArray;
import org.tensorflow.tools.ndarray.NdArray;
import org.tensorflow.tools.ndarray.StdArrays;
import org.tensorflow.types.TFloat64Impl;
import org.tensorflow.types.family.TNumber;

public interface TFloat64
extends DoubleNdArray,
TNumber {
    public static final DataType<TFloat64> DTYPE = DataType.create("DOUBLE", 2, 8, TFloat64Impl::mapTensor);

    public static Tensor<TFloat64> scalarOf(double value) {
        return Tensor.of(DTYPE, Shape.scalar(), data -> data.setDouble(value, new long[0]));
    }

    public static Tensor<TFloat64> vectorOf(double ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        return Tensor.of(DTYPE, Shape.of(values.length), data -> StdArrays.copyTo((DoubleNdArray)data, values));
    }

    public static Tensor<TFloat64> tensorOf(NdArray<Double> src) {
        return Tensor.of(DTYPE, src.shape(), src::copyTo);
    }

    public static Tensor<TFloat64> tensorOf(Shape shape) {
        return Tensor.of(DTYPE, shape);
    }

    public static Tensor<TFloat64> tensorOf(Shape shape, DoubleDataBuffer data) {
        return Tensor.of(DTYPE, shape, d -> d.write(data));
    }

    public static Tensor<TFloat64> tensorOf(Shape shape, Consumer<TFloat64> dataInit) {
        return Tensor.of(DTYPE, shape, dataInit);
    }
}

