/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.ndarray.impl.sequence;

import java.util.Iterator;
import java.util.function.BiConsumer;
import org.tensorflow.tools.ndarray.NdArray;
import org.tensorflow.tools.ndarray.NdArraySequence;
import org.tensorflow.tools.ndarray.impl.AbstractNdArray;
import org.tensorflow.tools.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.tools.ndarray.impl.sequence.PositionIterator;
import org.tensorflow.tools.ndarray.impl.sequence.SingleElementSequence;

public class ElementSequence<T, U extends NdArray<T>>
implements NdArraySequence<U> {
    private final AbstractNdArray<T, U> ndArray;
    private final int dimensionIdx;

    public static <T, U extends NdArray<T>> NdArraySequence<U> create(AbstractNdArray<T, U> ndArray, int dimensionIdx) {
        if (ndArray.rank() == 0 && dimensionIdx < 0) {
            return new SingleElementSequence<T, U>(ndArray);
        }
        return new ElementSequence<T, U>(ndArray, dimensionIdx);
    }

    @Override
    public Iterator<U> iterator() {
        final DimensionalSpace elementDimensions = this.ndArray.dimensions().from(this.dimensionIdx + 1);
        final PositionIterator positionIterator = PositionIterator.create(this.ndArray.dimensions(), this.dimensionIdx);
        return new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return positionIterator.hasNext();
            }

            @Override
            public U next() {
                return ElementSequence.this.ndArray.slice(positionIterator.next(), elementDimensions);
            }
        };
    }

    @Override
    public void forEachIndexed(BiConsumer<long[], U> consumer) {
        DimensionalSpace elementDimensions = this.ndArray.dimensions().from(this.dimensionIdx + 1);
        PositionIterator.createIndexed(this.ndArray.dimensions(), this.dimensionIdx).forEachIndexed((long[] coords, long position) -> consumer.accept(coords, this.ndArray.slice(position, elementDimensions)));
    }

    private ElementSequence(AbstractNdArray<T, U> ndArray, int dimensionIdx) {
        this.ndArray = ndArray;
        this.dimensionIdx = dimensionIdx;
    }
}

