/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.ndarray;

import org.tensorflow.tools.Shape;
import org.tensorflow.tools.ndarray.BooleanNdArray;
import org.tensorflow.tools.ndarray.ByteNdArray;
import org.tensorflow.tools.ndarray.DoubleNdArray;
import org.tensorflow.tools.ndarray.FloatNdArray;
import org.tensorflow.tools.ndarray.IntNdArray;
import org.tensorflow.tools.ndarray.LongNdArray;
import org.tensorflow.tools.ndarray.NdArray;
import org.tensorflow.tools.ndarray.NdArrays;
import org.tensorflow.tools.ndarray.ShortNdArray;

public final class StdArrays {
    public static IntNdArray ndCopyOf(int[] array) {
        IntNdArray ndArray = NdArrays.ofInts(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static IntNdArray ndCopyOf(int[][] array) {
        IntNdArray ndArray = NdArrays.ofInts(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static IntNdArray ndCopyOf(int[][][] array) {
        IntNdArray ndArray = NdArrays.ofInts(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static IntNdArray ndCopyOf(int[][][][] array) {
        IntNdArray ndArray = NdArrays.ofInts(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static IntNdArray ndCopyOf(int[][][][][] array) {
        IntNdArray ndArray = NdArrays.ofInts(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static IntNdArray ndCopyOf(int[][][][][][] array) {
        IntNdArray ndArray = NdArrays.ofInts(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static LongNdArray ndCopyOf(long[] array) {
        LongNdArray ndArray = NdArrays.ofLongs(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static LongNdArray ndCopyOf(long[][] array) {
        LongNdArray ndArray = NdArrays.ofLongs(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static LongNdArray ndCopyOf(long[][][] array) {
        LongNdArray ndArray = NdArrays.ofLongs(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static LongNdArray ndCopyOf(long[][][][] array) {
        LongNdArray ndArray = NdArrays.ofLongs(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static LongNdArray ndCopyOf(long[][][][][] array) {
        LongNdArray ndArray = NdArrays.ofLongs(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static LongNdArray ndCopyOf(long[][][][][][] array) {
        LongNdArray ndArray = NdArrays.ofLongs(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static FloatNdArray ndCopyOf(float[] array) {
        FloatNdArray ndArray = NdArrays.ofFloats(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static FloatNdArray ndCopyOf(float[][] array) {
        FloatNdArray ndArray = NdArrays.ofFloats(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static FloatNdArray ndCopyOf(float[][][] array) {
        FloatNdArray ndArray = NdArrays.ofFloats(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static FloatNdArray ndCopyOf(float[][][][] array) {
        FloatNdArray ndArray = NdArrays.ofFloats(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static FloatNdArray ndCopyOf(float[][][][][] array) {
        FloatNdArray ndArray = NdArrays.ofFloats(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static FloatNdArray ndCopyOf(float[][][][][][] array) {
        FloatNdArray ndArray = NdArrays.ofFloats(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static DoubleNdArray ndCopyOf(double[] array) {
        DoubleNdArray ndArray = NdArrays.ofDoubles(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static DoubleNdArray ndCopyOf(double[][] array) {
        DoubleNdArray ndArray = NdArrays.ofDoubles(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static DoubleNdArray ndCopyOf(double[][][] array) {
        DoubleNdArray ndArray = NdArrays.ofDoubles(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static DoubleNdArray ndCopyOf(double[][][][] array) {
        DoubleNdArray ndArray = NdArrays.ofDoubles(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static DoubleNdArray ndCopyOf(double[][][][][] array) {
        DoubleNdArray ndArray = NdArrays.ofDoubles(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static DoubleNdArray ndCopyOf(double[][][][][][] array) {
        DoubleNdArray ndArray = NdArrays.ofDoubles(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static ByteNdArray ndCopyOf(byte[] array) {
        ByteNdArray ndArray = NdArrays.ofBytes(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static ByteNdArray ndCopyOf(byte[][] array) {
        ByteNdArray ndArray = NdArrays.ofBytes(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static ByteNdArray ndCopyOf(byte[][][] array) {
        ByteNdArray ndArray = NdArrays.ofBytes(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static ByteNdArray ndCopyOf(byte[][][][] array) {
        ByteNdArray ndArray = NdArrays.ofBytes(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static ByteNdArray ndCopyOf(byte[][][][][] array) {
        ByteNdArray ndArray = NdArrays.ofBytes(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static ByteNdArray ndCopyOf(byte[][][][][][] array) {
        ByteNdArray ndArray = NdArrays.ofBytes(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static ShortNdArray ndCopyOf(short[] array) {
        ShortNdArray ndArray = NdArrays.ofShorts(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static ShortNdArray ndCopyOf(short[][] array) {
        ShortNdArray ndArray = NdArrays.ofShorts(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static ShortNdArray ndCopyOf(short[][][] array) {
        ShortNdArray ndArray = NdArrays.ofShorts(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static ShortNdArray ndCopyOf(short[][][][] array) {
        ShortNdArray ndArray = NdArrays.ofShorts(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static ShortNdArray ndCopyOf(short[][][][][] array) {
        ShortNdArray ndArray = NdArrays.ofShorts(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static ShortNdArray ndCopyOf(short[][][][][][] array) {
        ShortNdArray ndArray = NdArrays.ofShorts(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static BooleanNdArray ndCopyOf(boolean[] array) {
        BooleanNdArray ndArray = NdArrays.ofBooleans(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static BooleanNdArray ndCopyOf(boolean[][] array) {
        BooleanNdArray ndArray = NdArrays.ofBooleans(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static BooleanNdArray ndCopyOf(boolean[][][] array) {
        BooleanNdArray ndArray = NdArrays.ofBooleans(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static BooleanNdArray ndCopyOf(boolean[][][][] array) {
        BooleanNdArray ndArray = NdArrays.ofBooleans(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static BooleanNdArray ndCopyOf(boolean[][][][][] array) {
        BooleanNdArray ndArray = NdArrays.ofBooleans(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static BooleanNdArray ndCopyOf(boolean[][][][][][] array) {
        BooleanNdArray ndArray = NdArrays.ofBooleans(StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static <T> NdArray<T> ndCopyOf(T[] array) {
        NdArray<T> ndArray = NdArrays.ofObjects(StdArrays.componentTypeOf(array), StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static <T> NdArray<T> ndCopyOf(T[][] array) {
        NdArray<T> ndArray = NdArrays.ofObjects(StdArrays.componentTypeOf(array), StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static <T> NdArray<T> ndCopyOf(T[][][] array) {
        NdArray<T> ndArray = NdArrays.ofObjects(StdArrays.componentTypeOf(array), StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static <T> NdArray<T> ndCopyOf(T[][][][] array) {
        NdArray<T> ndArray = NdArrays.ofObjects(StdArrays.componentTypeOf(array), StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static <T> NdArray<T> ndCopyOf(T[][][][][] array) {
        NdArray<T> ndArray = NdArrays.ofObjects(StdArrays.componentTypeOf(array), StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static <T> NdArray<T> ndCopyOf(T[][][][][][] array) {
        NdArray<T> ndArray = NdArrays.ofObjects(StdArrays.componentTypeOf(array), StdArrays.shapeOf(array));
        StdArrays.copyTo(ndArray, array);
        return ndArray;
    }

    public static void copyTo(IntNdArray dst, int[] array) {
        NdArrays.vectorOf(array).copyTo((NdArray)dst);
    }

    public static void copyTo(IntNdArray dst, int[][] array) {
        dst.elements(0).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]]).copyTo((NdArray)e));
    }

    public static void copyTo(IntNdArray dst, int[][][] array) {
        dst.elements(1).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]]).copyTo((NdArray)e));
    }

    public static void copyTo(IntNdArray dst, int[][][][] array) {
        dst.elements(2).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]][(int)idx[2]]).copyTo((NdArray)e));
    }

    public static void copyTo(IntNdArray dst, int[][][][][] array) {
        dst.elements(3).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]).copyTo((NdArray)e));
    }

    public static void copyTo(IntNdArray dst, int[][][][][][] array) {
        dst.elements(4).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]).copyTo((NdArray)e));
    }

    public static void copyTo(LongNdArray dst, long[] array) {
        NdArrays.vectorOf(array).copyTo((NdArray)dst);
    }

    public static void copyTo(LongNdArray dst, long[][] array) {
        dst.elements(0).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]]).copyTo((NdArray)e));
    }

    public static void copyTo(LongNdArray dst, long[][][] array) {
        dst.elements(1).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]]).copyTo((NdArray)e));
    }

    public static void copyTo(LongNdArray dst, long[][][][] array) {
        dst.elements(2).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]][(int)idx[2]]).copyTo((NdArray)e));
    }

    public static void copyTo(LongNdArray dst, long[][][][][] array) {
        dst.elements(3).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]).copyTo((NdArray)e));
    }

    public static void copyTo(LongNdArray dst, long[][][][][][] array) {
        dst.elements(4).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]).copyTo((NdArray)e));
    }

    public static void copyTo(FloatNdArray dst, float[] array) {
        NdArrays.vectorOf(array).copyTo((NdArray)dst);
    }

    public static void copyTo(FloatNdArray dst, float[][] array) {
        dst.elements(0).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]]).copyTo((NdArray)e));
    }

    public static void copyTo(FloatNdArray dst, float[][][] array) {
        dst.elements(1).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]]).copyTo((NdArray)e));
    }

    public static void copyTo(FloatNdArray dst, float[][][][] array) {
        dst.elements(2).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]][(int)idx[2]]).copyTo((NdArray)e));
    }

    public static void copyTo(FloatNdArray dst, float[][][][][] array) {
        dst.elements(3).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]).copyTo((NdArray)e));
    }

    public static void copyTo(FloatNdArray dst, float[][][][][][] array) {
        dst.elements(4).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]).copyTo((NdArray)e));
    }

    public static void copyTo(DoubleNdArray dst, double[] array) {
        NdArrays.vectorOf(array).copyTo((NdArray)dst);
    }

    public static void copyTo(DoubleNdArray dst, double[][] array) {
        dst.elements(0).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]]).copyTo((NdArray)e));
    }

    public static void copyTo(DoubleNdArray dst, double[][][] array) {
        dst.elements(1).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]]).copyTo((NdArray)e));
    }

    public static void copyTo(DoubleNdArray dst, double[][][][] array) {
        dst.elements(2).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]][(int)idx[2]]).copyTo((NdArray)e));
    }

    public static void copyTo(DoubleNdArray dst, double[][][][][] array) {
        dst.elements(3).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]).copyTo((NdArray)e));
    }

    public static void copyTo(DoubleNdArray dst, double[][][][][][] array) {
        dst.elements(4).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]).copyTo((NdArray)e));
    }

    public static void copyTo(ByteNdArray dst, byte[] array) {
        NdArrays.vectorOf(array).copyTo((NdArray)dst);
    }

    public static void copyTo(ByteNdArray dst, byte[][] array) {
        dst.elements(0).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]]).copyTo((NdArray)e));
    }

    public static void copyTo(ByteNdArray dst, byte[][][] array) {
        dst.elements(1).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]]).copyTo((NdArray)e));
    }

    public static void copyTo(ByteNdArray dst, byte[][][][] array) {
        dst.elements(2).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]][(int)idx[2]]).copyTo((NdArray)e));
    }

    public static void copyTo(ByteNdArray dst, byte[][][][][] array) {
        dst.elements(3).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]).copyTo((NdArray)e));
    }

    public static void copyTo(ByteNdArray dst, byte[][][][][][] array) {
        dst.elements(4).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]).copyTo((NdArray)e));
    }

    public static void copyTo(ShortNdArray dst, short[] array) {
        NdArrays.vectorOf(array).copyTo((NdArray)dst);
    }

    public static void copyTo(ShortNdArray dst, short[][] array) {
        dst.elements(0).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]]).copyTo((NdArray)e));
    }

    public static void copyTo(ShortNdArray dst, short[][][] array) {
        dst.elements(1).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]]).copyTo((NdArray)e));
    }

    public static void copyTo(ShortNdArray dst, short[][][][] array) {
        dst.elements(2).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]][(int)idx[2]]).copyTo((NdArray)e));
    }

    public static void copyTo(ShortNdArray dst, short[][][][][] array) {
        dst.elements(3).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]).copyTo((NdArray)e));
    }

    public static void copyTo(ShortNdArray dst, short[][][][][][] array) {
        dst.elements(4).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]).copyTo((NdArray)e));
    }

    public static void copyTo(BooleanNdArray dst, boolean[] array) {
        NdArrays.vectorOf(array).copyTo((NdArray)dst);
    }

    public static void copyTo(BooleanNdArray dst, boolean[][] array) {
        dst.elements(0).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]]).copyTo((NdArray)e));
    }

    public static void copyTo(BooleanNdArray dst, boolean[][][] array) {
        dst.elements(1).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]]).copyTo((NdArray)e));
    }

    public static void copyTo(BooleanNdArray dst, boolean[][][][] array) {
        dst.elements(2).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]][(int)idx[2]]).copyTo((NdArray)e));
    }

    public static void copyTo(BooleanNdArray dst, boolean[][][][][] array) {
        dst.elements(3).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]).copyTo((NdArray)e));
    }

    public static void copyTo(BooleanNdArray dst, boolean[][][][][][] array) {
        dst.elements(4).forEachIndexed((idx, e) -> NdArrays.vectorOf(array[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]).copyTo((NdArray)e));
    }

    public static <T> void copyTo(NdArray<T> dst, T[] array) {
        NdArrays.vectorOfObjects(array).copyTo(dst);
    }

    public static <T> void copyTo(NdArray<T> dst, T[][] array) {
        dst.elements(0).forEachIndexed((idx, e) -> NdArrays.vectorOfObjects(array[(int)idx[0]]).copyTo((NdArray<Object>)e));
    }

    public static <T> void copyTo(NdArray<T> dst, T[][][] array) {
        dst.elements(1).forEachIndexed((idx, e) -> NdArrays.vectorOfObjects(array[(int)idx[0]][(int)idx[1]]).copyTo((NdArray<Object>)e));
    }

    public static <T> void copyTo(NdArray<T> dst, T[][][][] array) {
        dst.elements(2).forEachIndexed((idx, e) -> NdArrays.vectorOfObjects(array[(int)idx[0]][(int)idx[1]][(int)idx[2]]).copyTo((NdArray<Object>)e));
    }

    public static <T> void copyTo(NdArray<T> dst, T[][][][][] array) {
        dst.elements(3).forEachIndexed((idx, e) -> NdArrays.vectorOfObjects(array[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]).copyTo((NdArray<Object>)e));
    }

    public static <T> void copyTo(NdArray<T> dst, T[][][][][][] array) {
        dst.elements(4).forEachIndexed((idx, e) -> NdArrays.vectorOfObjects(array[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]).copyTo((NdArray<Object>)e));
    }

    public static Shape shapeOf(int[] array) {
        return Shape.of(array.length);
    }

    public static Shape shapeOf(int[][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[2]));
    }

    public static Shape shapeOf(int[][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[3]));
    }

    public static Shape shapeOf(int[][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[4]));
    }

    public static Shape shapeOf(int[][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[5]));
    }

    public static Shape shapeOf(int[][][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[6]));
    }

    public static Shape shapeOf(long[] array) {
        return Shape.of(array.length);
    }

    public static Shape shapeOf(long[][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[2]));
    }

    public static Shape shapeOf(long[][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[3]));
    }

    public static Shape shapeOf(long[][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[4]));
    }

    public static Shape shapeOf(long[][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[5]));
    }

    public static Shape shapeOf(long[][][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[6]));
    }

    public static Shape shapeOf(float[] array) {
        return Shape.of(array.length);
    }

    public static Shape shapeOf(float[][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[2]));
    }

    public static Shape shapeOf(float[][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[3]));
    }

    public static Shape shapeOf(float[][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[4]));
    }

    public static Shape shapeOf(float[][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[5]));
    }

    public static Shape shapeOf(float[][][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[6]));
    }

    public static Shape shapeOf(double[] array) {
        return Shape.of(array.length);
    }

    public static Shape shapeOf(double[][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[2]));
    }

    public static Shape shapeOf(double[][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[3]));
    }

    public static Shape shapeOf(double[][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[4]));
    }

    public static Shape shapeOf(double[][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[5]));
    }

    public static Shape shapeOf(double[][][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[6]));
    }

    public static Shape shapeOf(byte[] array) {
        return Shape.of(array.length);
    }

    public static Shape shapeOf(byte[][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[2]));
    }

    public static Shape shapeOf(byte[][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[3]));
    }

    public static Shape shapeOf(byte[][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[4]));
    }

    public static Shape shapeOf(byte[][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[5]));
    }

    public static Shape shapeOf(byte[][][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[6]));
    }

    public static Shape shapeOf(short[] array) {
        return Shape.of(array.length);
    }

    public static Shape shapeOf(short[][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[2]));
    }

    public static Shape shapeOf(short[][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[3]));
    }

    public static Shape shapeOf(short[][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[4]));
    }

    public static Shape shapeOf(short[][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[5]));
    }

    public static Shape shapeOf(short[][][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[6]));
    }

    public static Shape shapeOf(boolean[] array) {
        return Shape.of(array.length);
    }

    public static Shape shapeOf(boolean[][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[2]));
    }

    public static Shape shapeOf(boolean[][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[3]));
    }

    public static Shape shapeOf(boolean[][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[4]));
    }

    public static Shape shapeOf(boolean[][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[5]));
    }

    public static Shape shapeOf(boolean[][][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[6]));
    }

    public static <T> Shape shapeOf(T[] array) {
        return Shape.of(array.length);
    }

    public static <T> Shape shapeOf(T[][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[2]));
    }

    public static <T> Shape shapeOf(T[][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[3]));
    }

    public static <T> Shape shapeOf(T[][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[4]));
    }

    public static <T> Shape shapeOf(T[][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[5]));
    }

    public static <T> Shape shapeOf(T[][][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[6]));
    }

    private static void dimSize(int arrayLength, long[] shape, int dimIdx) {
        if (shape[dimIdx] == 0L) {
            shape[dimIdx] = arrayLength;
        } else if (shape[dimIdx] != (long)arrayLength) {
            shape[dimIdx] = Shape.UNKNOWN_SIZE;
        }
    }

    private static long[] computeShape(int[][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 2);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                throw new IllegalStateException("One of the subarray is null");
            }
            StdArrays.dimSize(array[i].length, shape, shape.length - 1);
        }
        return shape;
    }

    private static long[] computeShape(int[][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 3);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(int[][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 4);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(int[][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 5);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(int[][][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 6);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(long[][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 2);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                throw new IllegalStateException("One of the subarray is null");
            }
            StdArrays.dimSize(array[i].length, shape, shape.length - 1);
        }
        return shape;
    }

    private static long[] computeShape(long[][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 3);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(long[][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 4);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(long[][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 5);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(long[][][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 6);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(float[][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 2);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                throw new IllegalStateException("One of the subarray is null");
            }
            StdArrays.dimSize(array[i].length, shape, shape.length - 1);
        }
        return shape;
    }

    private static long[] computeShape(float[][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 3);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(float[][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 4);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(float[][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 5);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(float[][][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 6);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(double[][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 2);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                throw new IllegalStateException("One of the subarray is null");
            }
            StdArrays.dimSize(array[i].length, shape, shape.length - 1);
        }
        return shape;
    }

    private static long[] computeShape(double[][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 3);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(double[][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 4);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(double[][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 5);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(double[][][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 6);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(byte[][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 2);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                throw new IllegalStateException("One of the subarray is null");
            }
            StdArrays.dimSize(array[i].length, shape, shape.length - 1);
        }
        return shape;
    }

    private static long[] computeShape(byte[][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 3);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(byte[][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 4);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(byte[][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 5);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(byte[][][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 6);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(short[][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 2);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                throw new IllegalStateException("One of the subarray is null");
            }
            StdArrays.dimSize(array[i].length, shape, shape.length - 1);
        }
        return shape;
    }

    private static long[] computeShape(short[][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 3);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(short[][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 4);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(short[][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 5);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(short[][][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 6);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(boolean[][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 2);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                throw new IllegalStateException("One of the subarray is null");
            }
            StdArrays.dimSize(array[i].length, shape, shape.length - 1);
        }
        return shape;
    }

    private static long[] computeShape(boolean[][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 3);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(boolean[][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 4);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(boolean[][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 5);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(boolean[][][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 6);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static <T> long[] computeShape(T[][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 2);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                throw new IllegalStateException("One of the subarray is null");
            }
            StdArrays.dimSize(array[i].length, shape, shape.length - 1);
        }
        return shape;
    }

    private static <T> long[] computeShape(T[][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 3);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static <T> long[] computeShape(T[][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 4);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static <T> long[] computeShape(T[][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 5);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static <T> long[] computeShape(T[][][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 6);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static <T> Class<T> componentTypeOf(Object array) {
        Class<?> componentType = array.getClass().getComponentType();
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
        }
        return componentType;
    }
}

