/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.buffer.impl.raw;

import java.nio.ShortBuffer;
import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.buffer.DataStorageVisitor;
import org.tensorflow.tools.buffer.ShortDataBuffer;
import org.tensorflow.tools.buffer.impl.Validator;
import org.tensorflow.tools.buffer.impl.raw.AbstractRawDataBuffer;
import org.tensorflow.tools.buffer.impl.raw.UnsafeMemoryHandle;

final class ShortRawDataBuffer
extends AbstractRawDataBuffer<Short, ShortDataBuffer>
implements ShortDataBuffer {
    @Override
    public short getShort(long index) {
        Validator.getArgs(this, index);
        return this.memory.getShort(index);
    }

    @Override
    public ShortDataBuffer setShort(short value, long index) {
        Validator.setArgs(this, index);
        this.memory.setShort(value, index);
        return this;
    }

    @Override
    public ShortDataBuffer read(short[] dst) {
        return (ShortDataBuffer)this.read(dst, dst.length);
    }

    @Override
    public ShortDataBuffer read(short[] dst, int offset, int length) {
        return (ShortDataBuffer)this.read(dst, dst.length, offset, length);
    }

    @Override
    public ShortDataBuffer write(short[] src) {
        return (ShortDataBuffer)this.write(src, src.length);
    }

    @Override
    public ShortDataBuffer write(short[] src, int offset, int length) {
        return (ShortDataBuffer)this.write(src, src.length, offset, length);
    }

    @Override
    public ShortDataBuffer copyTo(final DataBuffer<Short> dst, final long size) {
        Validator.copyToArgs(this, dst, size);
        return dst.accept(new DataStorageVisitor<ShortDataBuffer>(){

            @Override
            public ShortDataBuffer visit(ShortBuffer buffer) {
                if (buffer.hasArray()) {
                    ShortRawDataBuffer.this.memory.copyTo(UnsafeMemoryHandle.fromArray(buffer.array(), buffer.position(), buffer.capacity()), size);
                } else if (ShortRawDataBuffer.this.memory.isArray()) {
                    buffer.put(ShortRawDataBuffer.this.memory.toArrayShortBuffer());
                } else {
                    ShortRawDataBuffer.this.slowCopyTo(dst, size);
                }
                return ShortRawDataBuffer.this;
            }

            @Override
            public ShortDataBuffer visit(long address, long length, long scale) {
                ShortRawDataBuffer.this.memory.copyTo(UnsafeMemoryHandle.fromAddress(address, length, scale), size);
                return ShortRawDataBuffer.this;
            }

            @Override
            public ShortDataBuffer fallback() {
                if (dst instanceof ShortDataBuffer) {
                    ShortDataBuffer shortDst = (ShortDataBuffer)dst;
                    for (long idx = 0L; idx < size; ++idx) {
                        shortDst.setShort(ShortRawDataBuffer.this.getShort(idx), idx);
                    }
                    return ShortRawDataBuffer.this;
                }
                return (ShortDataBuffer)ShortRawDataBuffer.this.slowCopyTo(dst, size);
            }
        });
    }

    @Override
    public <R> R accept(DataStorageVisitor<R> visitor) {
        if (this.memory.isArray()) {
            return visitor.visit(this.memory.toArrayShortBuffer());
        }
        return visitor.visit(this.memory.byteOffset, this.memory.byteSize, this.memory.scale);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShortDataBuffer)) {
            return super.equals(obj);
        }
        final ShortDataBuffer other = (ShortDataBuffer)obj;
        if (this.size() != other.size()) {
            return false;
        }
        return other.accept(new DataStorageVisitor<Boolean>(){

            @Override
            public Boolean visit(ShortBuffer buffer) {
                if (ShortRawDataBuffer.this.memory.isArray()) {
                    return buffer.equals(ShortRawDataBuffer.this.memory.toArrayShortBuffer());
                }
                return this.fallback();
            }

            @Override
            public Boolean fallback() {
                for (long idx = 0L; idx < ShortRawDataBuffer.this.size(); ++idx) {
                    if (other.getShort(idx) == ShortRawDataBuffer.this.getShort(idx)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    protected ShortDataBuffer instantiate(UnsafeMemoryHandle memory) {
        return new ShortRawDataBuffer(memory, this.readOnly);
    }

    ShortRawDataBuffer(UnsafeMemoryHandle memory, boolean readOnly) {
        super(memory, readOnly);
    }
}

