/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.buffer.impl.adapter;

import org.tensorflow.tools.buffer.BooleanDataBuffer;
import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.buffer.impl.Validator;
import org.tensorflow.tools.buffer.impl.adapter.AbstractDataBufferAdapter;
import org.tensorflow.tools.buffer.layout.BooleanDataLayout;

class BooleanDataBufferAdapter<S extends DataBuffer<?>>
extends AbstractDataBufferAdapter<S, Boolean, BooleanDataBuffer>
implements BooleanDataBuffer {
    private BooleanDataLayout<S> layout;

    @Override
    public boolean getBoolean(long index) {
        Validator.getArgs(this, index);
        return this.layout.readBoolean(this.buffer(), index * (long)this.layout.scale());
    }

    @Override
    public BooleanDataBuffer setBoolean(boolean value, long index) {
        Validator.setArgs(this, index);
        this.layout.writeBoolean(this.buffer(), value, index * (long)this.layout.scale());
        return this;
    }

    @Override
    public BooleanDataBuffer read(boolean[] dst, int offset, int length) {
        Validator.readArgs(this, dst.length, offset, length);
        int i = 0;
        int j = offset;
        while (i < length) {
            dst[j] = this.layout.readBoolean(this.buffer(), i * this.layout.scale());
            ++i;
            ++j;
        }
        return this;
    }

    @Override
    public BooleanDataBuffer write(boolean[] src, int offset, int length) {
        Validator.writeArgs(this, src.length, offset, length);
        int i = 0;
        int j = offset;
        while (i < length) {
            this.layout.writeBoolean(this.buffer(), src[j], i * this.layout.scale());
            ++i;
            ++j;
        }
        return this;
    }

    @Override
    public BooleanDataBuffer copyTo(DataBuffer<Boolean> dst, long size) {
        Validator.copyToArgs(this, dst, size);
        if (dst instanceof BooleanDataBuffer) {
            BooleanDataBuffer booleanDst = (BooleanDataBuffer)dst;
            for (long idx = 0L; idx < size; ++idx) {
                booleanDst.setBoolean(this.getBoolean(idx), idx);
            }
            return this;
        }
        return (BooleanDataBuffer)this.slowCopyTo(dst, size);
    }

    @Override
    public BooleanDataBuffer offset(long index) {
        return new BooleanDataBufferAdapter(this.buffer().offset(index * (long)this.layout.scale()), this.layout);
    }

    @Override
    public BooleanDataBuffer narrow(long size) {
        return new BooleanDataBufferAdapter(this.buffer().narrow(size * (long)this.layout.scale()), this.layout);
    }

    @Override
    public BooleanDataBuffer slice(long index, long size) {
        return new BooleanDataBufferAdapter(this.buffer().slice(index * (long)this.layout.scale(), size * (long)this.layout.scale()), this.layout);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BooleanDataBuffer)) {
            return super.equals(obj);
        }
        BooleanDataBuffer other = (BooleanDataBuffer)obj;
        if (other.size() != this.size()) {
            return false;
        }
        for (long idx = 0L; idx < this.size(); ++idx) {
            if (other.getBoolean(idx) == this.getBoolean(idx)) continue;
            return false;
        }
        return true;
    }

    BooleanDataBufferAdapter(S buffer, BooleanDataLayout<S> layout) {
        super(buffer, layout);
        this.layout = layout;
    }
}

