/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.proto.util;

import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.proto.util.SnapshotMetadataRecordOrBuilder;
import org.tensorflow.proto.util.SnapshotProtos;

public final class SnapshotMetadataRecord
extends GeneratedMessageV3
implements SnapshotMetadataRecordOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int GRAPH_HASH_FIELD_NUMBER = 1;
    private volatile Object graphHash_;
    public static final int RUN_ID_FIELD_NUMBER = 2;
    private volatile Object runId_;
    public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 3;
    private long creationTimestamp_;
    public static final int VERSION_FIELD_NUMBER = 4;
    private long version_;
    public static final int DTYPE_FIELD_NUMBER = 5;
    private List<Integer> dtype_;
    private static final Internal.ListAdapter.Converter<Integer, DataType> dtype_converter_ = new Internal.ListAdapter.Converter<Integer, DataType>(){

        @Override
        public DataType convert(Integer from) {
            DataType result = DataType.valueOf(from);
            return result == null ? DataType.UNRECOGNIZED : result;
        }
    };
    private int dtypeMemoizedSerializedSize;
    public static final int FINALIZED_FIELD_NUMBER = 1000;
    private boolean finalized_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final SnapshotMetadataRecord DEFAULT_INSTANCE = new SnapshotMetadataRecord();
    private static final Parser<SnapshotMetadataRecord> PARSER = new AbstractParser<SnapshotMetadataRecord>(){

        @Override
        public SnapshotMetadataRecord parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new SnapshotMetadataRecord(input, extensionRegistry);
        }
    };

    private SnapshotMetadataRecord(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private SnapshotMetadataRecord() {
        this.graphHash_ = "";
        this.runId_ = "";
        this.dtype_ = Collections.emptyList();
    }

    @Override
    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new SnapshotMetadataRecord();
    }

    @Override
    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private SnapshotMetadataRecord(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        boolean mutable_bitField0_ = false;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block16: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block16;
                    }
                    case 10: {
                        String s = input.readStringRequireUtf8();
                        this.graphHash_ = s;
                        continue block16;
                    }
                    case 18: {
                        String s = input.readStringRequireUtf8();
                        this.runId_ = s;
                        continue block16;
                    }
                    case 24: {
                        this.creationTimestamp_ = input.readInt64();
                        continue block16;
                    }
                    case 32: {
                        this.version_ = input.readInt64();
                        continue block16;
                    }
                    case 40: {
                        int rawValue = input.readEnum();
                        if (!(mutable_bitField0_ & true)) {
                            this.dtype_ = new ArrayList<Integer>();
                            mutable_bitField0_ |= true;
                        }
                        this.dtype_.add(rawValue);
                        continue block16;
                    }
                    case 42: {
                        int length = input.readRawVarint32();
                        int oldLimit = input.pushLimit(length);
                        while (input.getBytesUntilLimit() > 0) {
                            int rawValue = input.readEnum();
                            if (!(mutable_bitField0_ & true)) {
                                this.dtype_ = new ArrayList<Integer>();
                                mutable_bitField0_ |= true;
                            }
                            this.dtype_.add(rawValue);
                        }
                        input.popLimit(oldLimit);
                        continue block16;
                    }
                    case 8000: {
                        this.finalized_ = input.readBool();
                        continue block16;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage(this);
        }
        finally {
            if (mutable_bitField0_ & true) {
                this.dtype_ = Collections.unmodifiableList(this.dtype_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return SnapshotProtos.internal_static_tensorflow_data_experimental_SnapshotMetadataRecord_descriptor;
    }

    @Override
    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return SnapshotProtos.internal_static_tensorflow_data_experimental_SnapshotMetadataRecord_fieldAccessorTable.ensureFieldAccessorsInitialized(SnapshotMetadataRecord.class, Builder.class);
    }

    @Override
    public String getGraphHash() {
        Object ref = this.graphHash_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.graphHash_ = s;
        return s;
    }

    @Override
    public ByteString getGraphHashBytes() {
        Object ref = this.graphHash_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.graphHash_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getRunId() {
        Object ref = this.runId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.runId_ = s;
        return s;
    }

    @Override
    public ByteString getRunIdBytes() {
        Object ref = this.runId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.runId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public long getCreationTimestamp() {
        return this.creationTimestamp_;
    }

    @Override
    public long getVersion() {
        return this.version_;
    }

    @Override
    public List<DataType> getDtypeList() {
        return new Internal.ListAdapter<Integer, DataType>(this.dtype_, dtype_converter_);
    }

    @Override
    public int getDtypeCount() {
        return this.dtype_.size();
    }

    @Override
    public DataType getDtype(int index) {
        return dtype_converter_.convert(this.dtype_.get(index));
    }

    @Override
    public List<Integer> getDtypeValueList() {
        return this.dtype_;
    }

    @Override
    public int getDtypeValue(int index) {
        return this.dtype_.get(index);
    }

    @Override
    public boolean getFinalized() {
        return this.finalized_;
    }

    @Override
    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        this.getSerializedSize();
        if (!this.getGraphHashBytes().isEmpty()) {
            GeneratedMessageV3.writeString(output, 1, this.graphHash_);
        }
        if (!this.getRunIdBytes().isEmpty()) {
            GeneratedMessageV3.writeString(output, 2, this.runId_);
        }
        if (this.creationTimestamp_ != 0L) {
            output.writeInt64(3, this.creationTimestamp_);
        }
        if (this.version_ != 0L) {
            output.writeInt64(4, this.version_);
        }
        if (this.getDtypeList().size() > 0) {
            output.writeUInt32NoTag(42);
            output.writeUInt32NoTag(this.dtypeMemoizedSerializedSize);
        }
        for (int i = 0; i < this.dtype_.size(); ++i) {
            output.writeEnumNoTag(this.dtype_.get(i));
        }
        if (this.finalized_) {
            output.writeBool(1000, this.finalized_);
        }
        this.unknownFields.writeTo(output);
    }

    @Override
    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!this.getGraphHashBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize(1, this.graphHash_);
        }
        if (!this.getRunIdBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize(2, this.runId_);
        }
        if (this.creationTimestamp_ != 0L) {
            size += CodedOutputStream.computeInt64Size(3, this.creationTimestamp_);
        }
        if (this.version_ != 0L) {
            size += CodedOutputStream.computeInt64Size(4, this.version_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.dtype_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag(this.dtype_.get(i));
        }
        size += dataSize;
        if (!this.getDtypeList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        this.dtypeMemoizedSerializedSize = dataSize;
        if (this.finalized_) {
            size += CodedOutputStream.computeBoolSize(1000, this.finalized_);
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SnapshotMetadataRecord)) {
            return super.equals(obj);
        }
        SnapshotMetadataRecord other = (SnapshotMetadataRecord)obj;
        if (!this.getGraphHash().equals(other.getGraphHash())) {
            return false;
        }
        if (!this.getRunId().equals(other.getRunId())) {
            return false;
        }
        if (this.getCreationTimestamp() != other.getCreationTimestamp()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (!this.dtype_.equals(other.dtype_)) {
            return false;
        }
        if (this.getFinalized() != other.getFinalized()) {
            return false;
        }
        return this.unknownFields.equals(other.unknownFields);
    }

    @Override
    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + SnapshotMetadataRecord.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getGraphHash().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getRunId().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + Internal.hashLong(this.getCreationTimestamp());
        hash = 37 * hash + 4;
        hash = 53 * hash + Internal.hashLong(this.getVersion());
        if (this.getDtypeCount() > 0) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.dtype_.hashCode();
        }
        hash = 37 * hash + 1000;
        hash = 53 * hash + Internal.hashBoolean(this.getFinalized());
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static SnapshotMetadataRecord parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static SnapshotMetadataRecord parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static SnapshotMetadataRecord parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static SnapshotMetadataRecord parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static SnapshotMetadataRecord parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static SnapshotMetadataRecord parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static SnapshotMetadataRecord parseFrom(InputStream input) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static SnapshotMetadataRecord parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static SnapshotMetadataRecord parseDelimitedFrom(InputStream input) throws IOException {
        return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static SnapshotMetadataRecord parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }

    public static SnapshotMetadataRecord parseFrom(CodedInputStream input) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static SnapshotMetadataRecord parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
    }

    @Override
    public Builder newBuilderForType() {
        return SnapshotMetadataRecord.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(SnapshotMetadataRecord prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @Override
    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @Override
    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static SnapshotMetadataRecord getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<SnapshotMetadataRecord> parser() {
        return PARSER;
    }

    public Parser<SnapshotMetadataRecord> getParserForType() {
        return PARSER;
    }

    @Override
    public SnapshotMetadataRecord getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements SnapshotMetadataRecordOrBuilder {
        private int bitField0_;
        private Object graphHash_ = "";
        private Object runId_ = "";
        private long creationTimestamp_;
        private long version_;
        private List<Integer> dtype_ = Collections.emptyList();
        private boolean finalized_;

        public static final Descriptors.Descriptor getDescriptor() {
            return SnapshotProtos.internal_static_tensorflow_data_experimental_SnapshotMetadataRecord_descriptor;
        }

        @Override
        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return SnapshotProtos.internal_static_tensorflow_data_experimental_SnapshotMetadataRecord_fieldAccessorTable.ensureFieldAccessorsInitialized(SnapshotMetadataRecord.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                // empty if block
            }
        }

        @Override
        public Builder clear() {
            super.clear();
            this.graphHash_ = "";
            this.runId_ = "";
            this.creationTimestamp_ = 0L;
            this.version_ = 0L;
            this.dtype_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFE;
            this.finalized_ = false;
            return this;
        }

        @Override
        public Descriptors.Descriptor getDescriptorForType() {
            return SnapshotProtos.internal_static_tensorflow_data_experimental_SnapshotMetadataRecord_descriptor;
        }

        @Override
        public SnapshotMetadataRecord getDefaultInstanceForType() {
            return SnapshotMetadataRecord.getDefaultInstance();
        }

        @Override
        public SnapshotMetadataRecord build() {
            SnapshotMetadataRecord result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException(result);
            }
            return result;
        }

        @Override
        public SnapshotMetadataRecord buildPartial() {
            SnapshotMetadataRecord result = new SnapshotMetadataRecord(this);
            int from_bitField0_ = this.bitField0_;
            result.graphHash_ = this.graphHash_;
            result.runId_ = this.runId_;
            result.creationTimestamp_ = this.creationTimestamp_;
            result.version_ = this.version_;
            if ((this.bitField0_ & 1) != 0) {
                this.dtype_ = Collections.unmodifiableList(this.dtype_);
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.dtype_ = this.dtype_;
            result.finalized_ = this.finalized_;
            this.onBuilt();
            return result;
        }

        @Override
        public Builder clone() {
            return (Builder)super.clone();
        }

        @Override
        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        @Override
        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        @Override
        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        @Override
        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        @Override
        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        @Override
        public Builder mergeFrom(Message other) {
            if (other instanceof SnapshotMetadataRecord) {
                return this.mergeFrom((SnapshotMetadataRecord)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(SnapshotMetadataRecord other) {
            if (other == SnapshotMetadataRecord.getDefaultInstance()) {
                return this;
            }
            if (!other.getGraphHash().isEmpty()) {
                this.graphHash_ = other.graphHash_;
                this.onChanged();
            }
            if (!other.getRunId().isEmpty()) {
                this.runId_ = other.runId_;
                this.onChanged();
            }
            if (other.getCreationTimestamp() != 0L) {
                this.setCreationTimestamp(other.getCreationTimestamp());
            }
            if (other.getVersion() != 0L) {
                this.setVersion(other.getVersion());
            }
            if (!other.dtype_.isEmpty()) {
                if (this.dtype_.isEmpty()) {
                    this.dtype_ = other.dtype_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureDtypeIsMutable();
                    this.dtype_.addAll(other.dtype_);
                }
                this.onChanged();
            }
            if (other.getFinalized()) {
                this.setFinalized(other.getFinalized());
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        @Override
        public final boolean isInitialized() {
            return true;
        }

        @Override
        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            SnapshotMetadataRecord parsedMessage = null;
            try {
                parsedMessage = (SnapshotMetadataRecord)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (SnapshotMetadataRecord)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public String getGraphHash() {
            Object ref = this.graphHash_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.graphHash_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getGraphHashBytes() {
            Object ref = this.graphHash_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.graphHash_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setGraphHash(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.graphHash_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearGraphHash() {
            this.graphHash_ = SnapshotMetadataRecord.getDefaultInstance().getGraphHash();
            this.onChanged();
            return this;
        }

        public Builder setGraphHashBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SnapshotMetadataRecord.checkByteStringIsUtf8(value);
            this.graphHash_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getRunId() {
            Object ref = this.runId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.runId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRunIdBytes() {
            Object ref = this.runId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.runId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRunId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.runId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearRunId() {
            this.runId_ = SnapshotMetadataRecord.getDefaultInstance().getRunId();
            this.onChanged();
            return this;
        }

        public Builder setRunIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            SnapshotMetadataRecord.checkByteStringIsUtf8(value);
            this.runId_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public long getCreationTimestamp() {
            return this.creationTimestamp_;
        }

        public Builder setCreationTimestamp(long value) {
            this.creationTimestamp_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearCreationTimestamp() {
            this.creationTimestamp_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getVersion() {
            return this.version_;
        }

        public Builder setVersion(long value) {
            this.version_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearVersion() {
            this.version_ = 0L;
            this.onChanged();
            return this;
        }

        private void ensureDtypeIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.dtype_ = new ArrayList<Integer>(this.dtype_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<DataType> getDtypeList() {
            return new Internal.ListAdapter(this.dtype_, dtype_converter_);
        }

        @Override
        public int getDtypeCount() {
            return this.dtype_.size();
        }

        @Override
        public DataType getDtype(int index) {
            return (DataType)dtype_converter_.convert(this.dtype_.get(index));
        }

        public Builder setDtype(int index, DataType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureDtypeIsMutable();
            this.dtype_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addDtype(DataType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureDtypeIsMutable();
            this.dtype_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllDtype(Iterable<? extends DataType> values) {
            this.ensureDtypeIsMutable();
            for (DataType dataType : values) {
                this.dtype_.add(dataType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearDtype() {
            this.dtype_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getDtypeValueList() {
            return Collections.unmodifiableList(this.dtype_);
        }

        @Override
        public int getDtypeValue(int index) {
            return this.dtype_.get(index);
        }

        public Builder setDtypeValue(int index, int value) {
            this.ensureDtypeIsMutable();
            this.dtype_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addDtypeValue(int value) {
            this.ensureDtypeIsMutable();
            this.dtype_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllDtypeValue(Iterable<Integer> values) {
            this.ensureDtypeIsMutable();
            for (int value : values) {
                this.dtype_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public boolean getFinalized() {
            return this.finalized_;
        }

        public Builder setFinalized(boolean value) {
            this.finalized_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearFinalized() {
            this.finalized_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        @Override
        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

