/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class ExtractImagePatches<T extends TType>
extends RawOp
implements Operand<T> {
    private Output<T> patches;

    public static <T extends TType> ExtractImagePatches<T> create(Scope scope, Operand<T> images, List<Long> ksizes, List<Long> strides, List<Long> rates, String padding) {
        OperationBuilder opBuilder = scope.env().opBuilder("ExtractImagePatches", scope.makeOpName("ExtractImagePatches"));
        opBuilder.addInput(images.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        long[] ksizesArray = new long[ksizes.size()];
        for (int i = 0; i < ksizesArray.length; ++i) {
            ksizesArray[i] = ksizes.get(i);
        }
        opBuilder.setAttr("ksizes", ksizesArray);
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        long[] ratesArray = new long[rates.size()];
        for (int i = 0; i < ratesArray.length; ++i) {
            ratesArray[i] = rates.get(i);
        }
        opBuilder.setAttr("rates", ratesArray);
        opBuilder.setAttr("padding", padding);
        return new ExtractImagePatches<T>(opBuilder.build());
    }

    public Output<T> patches() {
        return this.patches;
    }

    @Override
    public Output<T> asOutput() {
        return this.patches;
    }

    private ExtractImagePatches(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.patches = operation.output(outputIdx++);
    }
}

