/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.debugging;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class DebugNumericsSummary<U extends TNumber>
extends RawOp
implements Operand<U> {
    private Output<U> output;

    public static <U extends TNumber, T extends TType> DebugNumericsSummary<U> create(Scope scope, Operand<T> input, DataType<U> outputDtype, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("DebugNumericSummaryV2", scope.makeOpName("DebugNumericsSummary"));
        opBuilder.addInput(input.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("output_dtype", outputDtype);
        if (options != null) {
            for (Options opts : options) {
                if (opts.tensorDebugMode != null) {
                    opBuilder.setAttr("tensor_debug_mode", opts.tensorDebugMode);
                }
                if (opts.tensorId == null) continue;
                opBuilder.setAttr("tensor_id", opts.tensorId);
            }
        }
        return new DebugNumericsSummary<U>(opBuilder.build());
    }

    public static <T extends TType> DebugNumericsSummary<TFloat32> create(Scope scope, Operand<T> input, Options ... options) {
        return DebugNumericsSummary.create(scope, input, TFloat32.DTYPE, options);
    }

    public static Options tensorDebugMode(Long tensorDebugMode) {
        return new Options().tensorDebugMode(tensorDebugMode);
    }

    public static Options tensorId(Long tensorId) {
        return new Options().tensorId(tensorId);
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    private DebugNumericsSummary(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Long tensorDebugMode;
        private Long tensorId;

        public Options tensorDebugMode(Long tensorDebugMode) {
            this.tensorDebugMode = tensorDebugMode;
            return this;
        }

        public Options tensorId(Long tensorId) {
            this.tensorId = tensorId;
            return this;
        }

        private Options() {
        }
    }
}

