/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.collective;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TNumber;

public final class AllReduce<T extends TNumber>
extends RawOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends TNumber> AllReduce<T> create(Scope scope, Operand<T> input, Long groupSize, Long groupKey, Long instanceKey, String mergeOp, String finalOp, List<Long> subdivOffsets, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("CollectiveReduce", scope.makeOpName("AllReduce"));
        opBuilder.addInput(input.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("group_size", groupSize);
        opBuilder.setAttr("group_key", groupKey);
        opBuilder.setAttr("instance_key", instanceKey);
        opBuilder.setAttr("merge_op", mergeOp);
        opBuilder.setAttr("final_op", finalOp);
        long[] subdivOffsetsArray = new long[subdivOffsets.size()];
        for (int i = 0; i < subdivOffsetsArray.length; ++i) {
            subdivOffsetsArray[i] = subdivOffsets.get(i);
        }
        opBuilder.setAttr("subdiv_offsets", subdivOffsetsArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.waitFor != null) {
                    long[] waitForArray = new long[opts.waitFor.size()];
                    for (int i = 0; i < waitForArray.length; ++i) {
                        waitForArray[i] = (Long)opts.waitFor.get(i);
                    }
                    opBuilder.setAttr("wait_for", waitForArray);
                }
                if (opts.communicationHint == null) continue;
                opBuilder.setAttr("communication_hint", opts.communicationHint);
            }
        }
        return new AllReduce<T>(opBuilder.build());
    }

    public static Options waitFor(List<Long> waitFor) {
        return new Options().waitFor(waitFor);
    }

    public static Options communicationHint(String communicationHint) {
        return new Options().communicationHint(communicationHint);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private AllReduce(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private List<Long> waitFor;
        private String communicationHint;

        public Options waitFor(List<Long> waitFor) {
            this.waitFor = waitFor;
            return this;
        }

        public Options communicationHint(String communicationHint) {
            this.communicationHint = communicationHint;
            return this;
        }

        private Options() {
        }
    }
}

