/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.buffer;

import org.bytedeco.javacpp.Pointer;
import org.tensorflow.internal.buffer.StringTensorBuffer;
import org.tensorflow.tools.buffer.BooleanDataBuffer;
import org.tensorflow.tools.buffer.ByteDataBuffer;
import org.tensorflow.tools.buffer.DoubleDataBuffer;
import org.tensorflow.tools.buffer.FloatDataBuffer;
import org.tensorflow.tools.buffer.IntDataBuffer;
import org.tensorflow.tools.buffer.LongDataBuffer;
import org.tensorflow.tools.buffer.ShortDataBuffer;
import org.tensorflow.tools.buffer.impl.raw.RawDataBufferFactory;

class TensorRawDataBufferFactory
extends RawDataBufferFactory {
    TensorRawDataBufferFactory() {
    }

    static ByteDataBuffer mapTensorToBytes(Pointer tensorMemory, boolean readOnly) {
        return TensorRawDataBufferFactory.mapNativeBytes(tensorMemory.address(), tensorMemory.capacity(), readOnly);
    }

    static IntDataBuffer mapTensorToInts(Pointer tensorMemory) {
        return TensorRawDataBufferFactory.mapNativeInts(tensorMemory.address(), tensorMemory.capacity(), false);
    }

    static LongDataBuffer mapTensorToLongs(Pointer tensorMemory) {
        return TensorRawDataBufferFactory.mapNativeLongs(tensorMemory.address(), tensorMemory.capacity(), false);
    }

    static FloatDataBuffer mapTensorToFloats(Pointer tensorMemory) {
        return TensorRawDataBufferFactory.mapNativeFloats(tensorMemory.address(), tensorMemory.capacity(), false);
    }

    static DoubleDataBuffer mapTensorToDoubles(Pointer tensorMemory) {
        return TensorRawDataBufferFactory.mapNativeDoubles(tensorMemory.address(), tensorMemory.capacity(), false);
    }

    static ShortDataBuffer mapTensorToShorts(Pointer tensorMemory) {
        return TensorRawDataBufferFactory.mapNativeShorts(tensorMemory.address(), tensorMemory.capacity(), false);
    }

    static BooleanDataBuffer mapTensorToBooleans(Pointer tensorMemory) {
        return TensorRawDataBufferFactory.mapNativeBooleans(tensorMemory.address(), tensorMemory.capacity(), false);
    }

    static StringTensorBuffer mapTensorToStrings(Pointer tensorMemory, long numElements) {
        long offsetByteSize = numElements * 8L;
        LongDataBuffer offsets = TensorRawDataBufferFactory.mapNativeLongs(tensorMemory.address(), offsetByteSize, false);
        ByteDataBuffer data = TensorRawDataBufferFactory.mapNativeBytes(tensorMemory.address() + offsetByteSize, tensorMemory.capacity() - offsetByteSize, false);
        return new StringTensorBuffer(offsets, data);
    }
}

