/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaSparseDenseMatmul", inputsClass=Inputs.class)
public final class XlaSparseDenseMatmul
extends RawOp {
    public static final String OP_NAME = "XlaSparseDenseMatmul";
    private Output<TFloat32> activations;
    private Output<TInt32> rowPointers;
    private Output<TInt32> sortedEmbeddingIds;
    private Output<TInt32> sortedSampleIds;
    private Output<TFloat32> sortedGains;

    public XlaSparseDenseMatmul(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.activations = operation.output(outputIdx++);
        this.rowPointers = operation.output(outputIdx++);
        this.sortedEmbeddingIds = operation.output(outputIdx++);
        this.sortedSampleIds = operation.output(outputIdx++);
        this.sortedGains = operation.output(outputIdx++);
    }

    public static XlaSparseDenseMatmul create(Scope scope, Operand<TInt32> rowIds, Operand<? extends TType> colIds, Operand<TFloat32> values, Operand<? extends TType> offsets, Operand<TFloat32> embeddingTable, Long maxIdsPerPartition, Long maxUniqueIdsPerPartition, Long inputSize) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(rowIds.asOutput());
        opBuilder.addInput(colIds.asOutput());
        opBuilder.addInput(values.asOutput());
        opBuilder.addInput(offsets.asOutput());
        opBuilder.addInput(embeddingTable.asOutput());
        opBuilder.setAttr("max_ids_per_partition", maxIdsPerPartition);
        opBuilder.setAttr("max_unique_ids_per_partition", maxUniqueIdsPerPartition);
        opBuilder.setAttr("input_size", inputSize);
        return new XlaSparseDenseMatmul(opBuilder.build());
    }

    public Output<TFloat32> activations() {
        return this.activations;
    }

    public Output<TInt32> rowPointers() {
        return this.rowPointers;
    }

    public Output<TInt32> sortedEmbeddingIds() {
        return this.sortedEmbeddingIds;
    }

    public Output<TInt32> sortedSampleIds() {
        return this.sortedSampleIds;
    }

    public Output<TFloat32> sortedGains() {
        return this.sortedGains;
    }

    @OpInputsMetadata(outputsClass=XlaSparseDenseMatmul.class)
    public static class Inputs
    extends RawOpInputs<XlaSparseDenseMatmul> {
        public final Operand<TInt32> rowIds;
        public final Operand<? extends TType> colIds;
        public final Operand<TFloat32> values;
        public final Operand<? extends TType> offsets;
        public final Operand<TFloat32> embeddingTable;
        public final long maxIdsPerPartition;
        public final long maxUniqueIdsPerPartition;
        public final long inputSize;

        public Inputs(GraphOperation op) {
            super(new XlaSparseDenseMatmul(op), op, Arrays.asList("max_ids_per_partition", "max_unique_ids_per_partition", "input_size"));
            int inputIndex = 0;
            this.rowIds = op.input(inputIndex++);
            this.colIds = op.input(inputIndex++);
            this.values = op.input(inputIndex++);
            this.offsets = op.input(inputIndex++);
            this.embeddingTable = op.input(inputIndex++);
            this.maxIdsPerPartition = op.attributes().getAttrInt("max_ids_per_partition");
            this.maxUniqueIdsPerPartition = op.attributes().getAttrInt("max_unique_ids_per_partition");
            this.inputSize = op.attributes().getAttrInt("input_size");
        }
    }
}

