/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TPUExecute", inputsClass=Inputs.class)
public final class Execute
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "TPUExecute";
    private List<Output<?>> results;

    public Execute(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int resultsLength = operation.outputListLength("results");
        this.results = Arrays.asList(operation.outputList(outputIdx, resultsLength));
        outputIdx += resultsLength;
    }

    public static Execute create(Scope scope, Iterable<Operand<?>> args, Operand<TString> key, List<Class<? extends TType>> Tresults) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Execute");
        opBuilder.addInputList(Operands.asOutputs(args));
        opBuilder.addInput(key.asOutput());
        opBuilder.setAttr("Tresults", Operands.toDataTypes(Tresults));
        return new Execute(opBuilder.build());
    }

    public List<Output<?>> results() {
        return this.results;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.results.iterator();
    }

    @OpInputsMetadata(outputsClass=Execute.class)
    public static class Inputs
    extends RawOpInputs<Execute> {
        public final Iterable<Operand<?>> args;
        public final Operand<TString> key;
        public final DataType[] Targs;
        public final DataType[] Tresults;

        public Inputs(GraphOperation op) {
            super(new Execute(op), op, Arrays.asList("Targs", "Tresults"));
            int inputIndex = 0;
            int argsLength = op.inputListLength("args");
            this.args = Arrays.asList((Operand[])op.inputList(inputIndex, argsLength));
            inputIndex += argsLength;
            this.key = op.input(inputIndex++);
            this.Targs = op.attributes().getAttrTypeList("Targs");
            this.Tresults = op.attributes().getAttrTypeList("Tresults");
        }
    }
}

