/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.signal;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="RFFT2D", inputsClass=Inputs.class)
public final class Rfft2d<U extends TType>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "RFFT2D";
    private Output<U> output;

    public Rfft2d(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <U extends TType> Rfft2d<U> create(Scope scope, Operand<? extends TNumber> input, Operand<TInt32> fftLength, Class<U> Tcomplex) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Rfft2d");
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(fftLength.asOutput());
        opBuilder.setAttr("Tcomplex", Operands.toDataType(Tcomplex));
        return new Rfft2d<U>(opBuilder.build());
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=Rfft2d.class)
    public static class Inputs
    extends RawOpInputs<Rfft2d<?>> {
        public final Operand<? extends TNumber> input;
        public final Operand<TInt32> fftLength;
        public final DataType Treal;
        public final DataType Tcomplex;

        public Inputs(GraphOperation op) {
            super(new Rfft2d(op), op, Arrays.asList("Treal", "Tcomplex"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.fftLength = op.input(inputIndex++);
            this.Treal = op.attributes().getAttrType("Treal");
            this.Tcomplex = op.attributes().getAttrType("Tcomplex");
        }
    }
}

