/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.random;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="RandomUniform", inputsClass=Inputs.class)
public final class RandomUniform<U extends TNumber>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "RandomUniform";
    private Output<U> output;

    public RandomUniform(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <U extends TNumber> RandomUniform<U> create(Scope scope, Operand<? extends TNumber> shape, Class<U> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(shape.asOutput());
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 == null) continue;
                opBuilder.setAttr("seed2", opts.seed2);
            }
        }
        return new RandomUniform<U>(opBuilder.build());
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=RandomUniform.class)
    public static class Inputs
    extends RawOpInputs<RandomUniform<?>> {
        public final Operand<? extends TNumber> shape;
        public final long seed;
        public final long seed2;
        public final DataType dtype;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new RandomUniform(op), op, Arrays.asList("seed", "seed2", "dtype", "T"));
            int inputIndex = 0;
            this.shape = op.input(inputIndex++);
            this.seed = op.attributes().getAttrInt("seed");
            this.seed2 = op.attributes().getAttrInt("seed2");
            this.dtype = op.attributes().getAttrType("dtype");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Long seed;
        private Long seed2;

        private Options() {
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }
    }
}

