/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SparseMatrixSoftmaxGrad", inputsClass=Inputs.class)
public final class SparseMatrixSoftmaxGrad
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "SparseMatrixSoftmaxGrad";
    private Output<? extends TType> gradient;

    public SparseMatrixSoftmaxGrad(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.gradient = operation.output(outputIdx++);
    }

    public static <T extends TNumber> SparseMatrixSoftmaxGrad create(Scope scope, Operand<? extends TType> softmax, Operand<? extends TType> gradSoftmax, Class<T> type) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(softmax.asOutput());
        opBuilder.addInput(gradSoftmax.asOutput());
        opBuilder.setAttr("type", Operands.toDataType(type));
        return new SparseMatrixSoftmaxGrad(opBuilder.build());
    }

    public Output<? extends TType> gradient() {
        return this.gradient;
    }

    @Override
    public Output<TType> asOutput() {
        return this.gradient;
    }

    @OpInputsMetadata(outputsClass=SparseMatrixSoftmaxGrad.class)
    public static class Inputs
    extends RawOpInputs<SparseMatrixSoftmaxGrad> {
        public final Operand<? extends TType> softmax;
        public final Operand<? extends TType> gradSoftmax;
        public final DataType type;

        public Inputs(GraphOperation op) {
            super(new SparseMatrixSoftmaxGrad(op), op, Arrays.asList("type"));
            int inputIndex = 0;
            this.softmax = op.input(inputIndex++);
            this.gradSoftmax = op.input(inputIndex++);
            this.type = op.attributes().getAttrType("type");
        }
    }
}

